/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import hellfirepvp.astralsorcery.common.tile.TileCelestialCrystals;
import hellfirepvp.astralsorcery.common.tile.TileFakeTree;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.tile.base.TileSourceBase;
import hellfirepvp.astralsorcery.common.tile.base.TileTransmissionBase;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileAccelerationBlacklist {
    private static List<String> blacklistedPrefixes = new LinkedList<String>();
    private static List<Class<?>> erroredTiles = new LinkedList();
    private static List<Class<?>> blacklistedClasses = new LinkedList();

    public static boolean canAccelerate(@Nullable TileEntity te) {
        if (te == null) {
            return false;
        }
        if (!(te instanceof ITickable)) {
            return false;
        }
        Class<?> tClass = te.getClass();
        String className = tClass.getName();
        String lCClassName = className.toLowerCase();
        for (String string : blacklistedPrefixes) {
            if (!lCClassName.startsWith(string)) continue;
            return false;
        }
        for (Class clazz : blacklistedClasses) {
            if (!clazz.isAssignableFrom(tClass)) continue;
            return false;
        }
        return !erroredTiles.contains(tClass);
    }

    @Deprecated
    public static void errored(Class<?> teClass) {
        if (!erroredTiles.contains(teClass)) {
            erroredTiles.add(teClass);
        }
    }

    public static void blacklistTileClassAndSubclasses(Class<?> tileClass) {
        if (!blacklistedClasses.contains(tileClass)) {
            blacklistedClasses.add(tileClass);
        }
    }

    public static void blacklistTileClassNamePrefix(String prefix) {
        if (!blacklistedPrefixes.contains(prefix.toLowerCase())) {
            blacklistedPrefixes.add(prefix.toLowerCase());
        }
    }

    public static void init() {
        TileAccelerationBlacklist.blacklistTileClassAndSubclasses(TileTransmissionBase.class);
        TileAccelerationBlacklist.blacklistTileClassAndSubclasses(TileSourceBase.class);
        TileAccelerationBlacklist.blacklistTileClassAndSubclasses(TileRitualPedestal.class);
        TileAccelerationBlacklist.blacklistTileClassAndSubclasses(TileAltar.class);
        TileAccelerationBlacklist.blacklistTileClassAndSubclasses(TileAttunementAltar.class);
        TileAccelerationBlacklist.blacklistTileClassAndSubclasses(TileCelestialCrystals.class);
        TileAccelerationBlacklist.blacklistTileClassAndSubclasses(TileFakeTree.class);
        TileAccelerationBlacklist.blacklistTileClassNamePrefix("appeng");
        TileAccelerationBlacklist.blacklistTileClassNamePrefix("raoulvdberge/refinedstorage");
    }
}

