/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.ClientGuiHandler;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.light.ClientLightbeamHandler;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightning;
import hellfirepvp.astralsorcery.client.event.ClientConnectionEventHandler;
import hellfirepvp.astralsorcery.client.event.ClientGatewayHandler;
import hellfirepvp.astralsorcery.client.event.ClientRenderEventHandler;
import hellfirepvp.astralsorcery.client.models.obj.OBJModelLibrary;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntityFlare;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntityHook;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntityItemHighlight;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntityNoOp;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntityStarburst;
import hellfirepvp.astralsorcery.client.render.entity.RenderLiquidSpark;
import hellfirepvp.astralsorcery.client.render.entity.RenderSpectralTool;
import hellfirepvp.astralsorcery.client.render.tile.TESRAltar;
import hellfirepvp.astralsorcery.client.render.tile.TESRAttunementAltar;
import hellfirepvp.astralsorcery.client.render.tile.TESRAttunementRelay;
import hellfirepvp.astralsorcery.client.render.tile.TESRCelestialCrystals;
import hellfirepvp.astralsorcery.client.render.tile.TESRChalice;
import hellfirepvp.astralsorcery.client.render.tile.TESRCollectorCrystal;
import hellfirepvp.astralsorcery.client.render.tile.TESRFakeTree;
import hellfirepvp.astralsorcery.client.render.tile.TESRGrindstone;
import hellfirepvp.astralsorcery.client.render.tile.TESRLens;
import hellfirepvp.astralsorcery.client.render.tile.TESRMapDrawingTable;
import hellfirepvp.astralsorcery.client.render.tile.TESRObservatory;
import hellfirepvp.astralsorcery.client.render.tile.TESRPrismLens;
import hellfirepvp.astralsorcery.client.render.tile.TESRRitualPedestal;
import hellfirepvp.astralsorcery.client.render.tile.TESRStarlightInfuser;
import hellfirepvp.astralsorcery.client.render.tile.TESRTelescope;
import hellfirepvp.astralsorcery.client.render.tile.TESRTranslucentBlock;
import hellfirepvp.astralsorcery.client.render.tile.TESRWell;
import hellfirepvp.astralsorcery.client.util.ItemColorizationHelper;
import hellfirepvp.astralsorcery.client.util.JournalRecipeDisplayRecovery;
import hellfirepvp.astralsorcery.client.util.camera.ClientCameraManager;
import hellfirepvp.astralsorcery.client.util.item.AstralTEISR;
import hellfirepvp.astralsorcery.client.util.item.DummyModelLoader;
import hellfirepvp.astralsorcery.client.util.item.ItemRenderRegistry;
import hellfirepvp.astralsorcery.client.util.item.ItemRendererFilteredTESR;
import hellfirepvp.astralsorcery.client.util.mappings.ClientJournalMapping;
import hellfirepvp.astralsorcery.client.util.mappings.ClientPerkTextureMapping;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.tick.TickManager;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.block.BlockDynamicColor;
import hellfirepvp.astralsorcery.common.block.BlockDynamicStateMapper;
import hellfirepvp.astralsorcery.common.block.BlockMachine;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.entities.EntityGrapplingHook;
import hellfirepvp.astralsorcery.common.entities.EntityIlluminationSpark;
import hellfirepvp.astralsorcery.common.entities.EntityItemHighlighted;
import hellfirepvp.astralsorcery.common.entities.EntityLiquidSpark;
import hellfirepvp.astralsorcery.common.entities.EntityNocturnalSpark;
import hellfirepvp.astralsorcery.common.entities.EntitySpectralTool;
import hellfirepvp.astralsorcery.common.entities.EntityStarburst;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationGeolosys;
import hellfirepvp.astralsorcery.common.item.base.IMetaItem;
import hellfirepvp.astralsorcery.common.item.base.IOBJItem;
import hellfirepvp.astralsorcery.common.item.base.render.INBTModel;
import hellfirepvp.astralsorcery.common.item.base.render.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryBlocks;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import hellfirepvp.astralsorcery.common.tile.TileAttunementRelay;
import hellfirepvp.astralsorcery.common.tile.TileCelestialCrystals;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.TileFakeTree;
import hellfirepvp.astralsorcery.common.tile.TileGrindstone;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.tile.TileTranslucent;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalPrismLens;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public static boolean connected = false;
    private final ClientScheduler scheduler = new ClientScheduler();
    private static List<RenderInfoBlock> blockRegister = new ArrayList<RenderInfoBlock>();
    private static List<RenderInfoItem> itemRegister = new ArrayList<RenderInfoItem>();

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)AssetLibrary.resReloadInstance);
        }
        catch (Exception exc) {
            AstralSorcery.log.warn("[AstralSorcery] Could not add AssetLibrary to resource manager! Texture reloading will have no effect on AstralSorcery textures.");
            AssetLibrary.resReloadInstance.func_110549_a(null);
        }
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new DummyModelLoader());
        OBJLoader.INSTANCE.addDomain("astralsorcery");
        super.preInit();
        CraftingAccessManager.ignoreJEI = false;
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        this.registerFluidRenderers();
        this.registerEntityRenderers();
        this.registerDisplayInformationInit();
        this.registerTileRenderers();
        this.registerItemRenderers();
    }

    private void registerPendingIBlockColorBlocks() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        for (BlockDynamicColor b : RegistryBlocks.pendingIBlockColorBlocks) {
            colors.func_186722_a(b::getColorMultiplier, new Block[]{(Block)b});
        }
    }

    private void registerPendingIItemColorItems() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        for (ItemDynamicColor i : RegistryItems.pendingDynamicColorItems) {
            colors.func_186730_a(i::getColorForItemStack, new Item[]{(Item)i});
        }
    }

    private void registerFluidRenderers() {
        this.registerFluidRender(BlocksAS.fluidLiquidStarlight);
    }

    private void registerFluidRender(Fluid f) {
        RegistryBlocks.FluidCustomModelMapper mapper = new RegistryBlocks.FluidCustomModelMapper(f);
        Block block = f.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            if (item != Items.field_190931_a) {
                ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
            } else {
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.registerPendingIBlockColorBlocks();
        this.registerPendingIItemColorItems();
        MinecraftForge.EVENT_BUS.register((Object)new ClientRenderEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientConnectionEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)EffectHandler.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)new ClientGatewayHandler());
    }

    @Override
    public void postInit() {
        super.postInit();
        TileEntityItemStackRenderer.field_147719_a = new AstralTEISR(TileEntityItemStackRenderer.field_147719_a);
        ClientJournalMapping.init();
        ClientPerkTextureMapping.init();
        OBJModelLibrary.init();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)ItemColorizationHelper.instance);
        JournalRecipeDisplayRecovery.attemptRecipeRecovery();
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id < 0 || id >= CommonProxy.EnumGuiId.values().length) {
            return null;
        }
        CommonProxy.EnumGuiId guiType = CommonProxy.EnumGuiId.values()[id];
        return ClientGuiHandler.openGui(guiType, player, world, x, y, z);
    }

    public void registerItemRenderers() {
        ItemRendererFilteredTESR blockMachineRender = new ItemRendererFilteredTESR();
        blockMachineRender.addRender(BlockMachine.MachineType.TELESCOPE.getMeta(), new TESRTelescope(), new TileTelescope());
        blockMachineRender.addRender(BlockMachine.MachineType.GRINDSTONE.getMeta(), new TESRGrindstone(), new TileGrindstone());
        ItemRenderRegistry.register(Item.func_150898_a((Block)BlocksAS.blockMachine), blockMachineRender);
        ItemRenderRegistry.register(Item.func_150898_a((Block)BlocksAS.collectorCrystal), new TESRCollectorCrystal());
        ItemRenderRegistry.register(Item.func_150898_a((Block)BlocksAS.celestialCollectorCrystal), new TESRCollectorCrystal());
        ItemRenderRegistry.register(Item.func_150898_a((Block)BlocksAS.celestialCrystals), new TESRCelestialCrystals());
        if (Mods.GEOLOSYS.isPresent() && Mods.ORESTAGES.isPresent()) {
            ModIntegrationGeolosys.registerGeolosysSampleItemRenderer();
        }
    }

    @Override
    protected void registerTickHandlers(TickManager manager) {
        super.registerTickHandlers(manager);
        manager.register(new ClientLightbeamHandler());
        manager.register(this.scheduler);
        manager.register(ClientCameraManager.getInstance());
    }

    @Override
    public void scheduleClientside(Runnable r, int tickDelay) {
        this.scheduler.addRunnable(r, tickDelay);
    }

    private void registerTileRenderers() {
        this.registerTESR(TileAltar.class, new TESRAltar());
        this.registerTESR(TileRitualPedestal.class, new TESRRitualPedestal());
        this.registerTESR(TileCollectorCrystal.class, new TESRCollectorCrystal());
        this.registerTESR(TileCelestialCrystals.class, new TESRCelestialCrystals());
        this.registerTESR(TileWell.class, new TESRWell());
        this.registerTESR(TileGrindstone.class, new TESRGrindstone());
        this.registerTESR(TileTelescope.class, new TESRTelescope());
        this.registerTESR(TileFakeTree.class, new TESRFakeTree());
        this.registerTESR(TileAttunementAltar.class, new TESRAttunementAltar());
        this.registerTESR(TileCrystalLens.class, new TESRLens());
        this.registerTESR(TileCrystalPrismLens.class, new TESRPrismLens());
        this.registerTESR(TileStarlightInfuser.class, new TESRStarlightInfuser());
        this.registerTESR(TileTranslucent.class, new TESRTranslucentBlock());
        this.registerTESR(TileAttunementRelay.class, new TESRAttunementRelay());
        this.registerTESR(TileMapDrawingTable.class, new TESRMapDrawingTable());
        this.registerTESR(TileChalice.class, new TESRChalice());
        this.registerTESR(TileObservatory.class, new TESRObservatory());
        if (Mods.GEOLOSYS.isPresent() && Mods.ORESTAGES.isPresent()) {
            ModIntegrationGeolosys.registerGeolosysSampleRender();
        }
    }

    private <T extends TileEntity> void registerTESR(Class<T> tile, TileEntitySpecialRenderer<T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tile, renderer);
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityItemHighlighted.class, (IRenderFactory)new RenderEntityItemHighlight.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlare.class, (IRenderFactory)new RenderEntityFlare.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityStarburst.class, (IRenderFactory)new RenderEntityStarburst.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityNocturnalSpark.class, new RenderEntityNoOp.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityIlluminationSpark.class, new RenderEntityNoOp.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrapplingHook.class, (IRenderFactory)new RenderEntityHook.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySpectralTool.class, (IRenderFactory)new RenderSpectralTool.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityLiquidSpark.class, (IRenderFactory)new RenderLiquidSpark.Factory());
    }

    public void registerDisplayInformationInit() {
        ModelResourceLocation def;
        Item item;
        for (RenderInfoItem renderInfoItem : itemRegister) {
            if (renderInfoItem.variant) {
                this.registerVariantName(renderInfoItem.item, renderInfoItem.name);
            }
            if (renderInfoItem.item instanceof IOBJItem) {
                if (!((IOBJItem)renderInfoItem.item).hasOBJAsSubmodelDefinition()) {
                    String[] models = ((IOBJItem)renderInfoItem.item).getOBJModelNames();
                    if (models == null) continue;
                    for (String modelDef : models) {
                        ModelResourceLocation mrl = new ModelResourceLocation("astralsorcery:obj/" + modelDef + ".obj", "inventory");
                        ModelBakery.registerItemVariants((Item)renderInfoItem.item, (ResourceLocation[])new ResourceLocation[]{mrl});
                        ModelLoader.setCustomModelResourceLocation((Item)renderInfoItem.item, (int)renderInfoItem.metadata, (ModelResourceLocation)mrl);
                    }
                    continue;
                }
                ModelResourceLocation mrl = new ModelResourceLocation("astralsorcery:obj/" + renderInfoItem.name, "inventory");
                ModelBakery.registerItemVariants((Item)renderInfoItem.item, (ResourceLocation[])new ResourceLocation[]{mrl});
                ModelLoader.setCustomModelResourceLocation((Item)renderInfoItem.item, (int)renderInfoItem.metadata, (ModelResourceLocation)mrl);
                continue;
            }
            item = renderInfoItem.item;
            def = new ModelResourceLocation("astralsorcery:" + renderInfoItem.name, "inventory");
            if (item instanceof INBTModel) {
                List<ResourceLocation> out = ((INBTModel)item).getAllPossibleLocations(def);
                ResourceLocation[] arr = new ResourceLocation[out.size()];
                arr = out.toArray(arr);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])arr);
                ModelLoader.setCustomMeshDefinition((Item)item, stack -> ((INBTModel)item).getModelLocation(stack, def));
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)renderInfoItem.metadata, (ModelResourceLocation)def);
        }
        for (RenderInfoBlock renderInfoBlock : blockRegister) {
            if (renderInfoBlock.block instanceof BlockDynamicStateMapper && ((BlockDynamicStateMapper)renderInfoBlock.block).handleRegisterStateMapper()) {
                ((BlockDynamicStateMapper)renderInfoBlock.block).registerStateMapper();
            }
            item = Item.func_150898_a((Block)renderInfoBlock.block);
            def = new ModelResourceLocation("astralsorcery:" + renderInfoBlock.name, "inventory");
            if (item instanceof INBTModel) {
                List<ResourceLocation> out = ((INBTModel)item).getAllPossibleLocations(def);
                ResourceLocation[] arr = new ResourceLocation[out.size()];
                arr = out.toArray(arr);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])arr);
                ModelLoader.setCustomMeshDefinition((Item)item, stack -> ((INBTModel)item).getModelLocation(stack, def));
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)renderInfoBlock.metadata, (ModelResourceLocation)def);
        }
    }

    @Override
    public void fireLightning(World world, Vector3 from, Vector3 to, Color overlay) {
        EffectLightning lightning = EffectHandler.getInstance().lightning(from, to);
        if (overlay != null) {
            lightning.setOverlayColor(overlay);
        }
    }

    @Override
    public void registerFromSubItems(Item item, String name) {
        if (item instanceof IMetaItem) {
            int[] additionalMetas = ((IMetaItem)item).getSubItems();
            if (additionalMetas != null) {
                for (int meta : additionalMetas) {
                    this.registerItemRender(item, meta, name);
                }
            }
            return;
        }
        NonNullList list = NonNullList.func_191196_a();
        item.func_150895_a(item.func_77640_w(), list);
        if (list.size() > 0) {
            for (ItemStack i : list) {
                this.registerItemRender(item, i.func_77952_i(), name);
            }
        } else {
            this.registerItemRender(item, 0, name);
        }
    }

    @Override
    public void registerVariantName(Item item, String name) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("astralsorcery", name)});
    }

    @Override
    public void registerBlockRender(Block block, int metadata, String name) {
        blockRegister.add(new RenderInfoBlock(block, metadata, name));
    }

    @Override
    public void registerItemRender(Item item, int metadata, String name) {
        this.registerItemRender(item, metadata, name, false);
    }

    public void registerItemRender(Item item, int metadata, String name, boolean variant) {
        itemRegister.add(new RenderInfoItem(item, metadata, name, variant));
    }

    private static class RenderInfoItem {
        public Item item;
        public int metadata;
        public String name;
        public boolean variant;

        public RenderInfoItem(Item item, int metadata, String name, boolean variant) {
            this.item = item;
            this.metadata = metadata;
            this.name = name;
            this.variant = variant;
        }
    }

    private static class RenderInfoBlock {
        public Block block;
        public int metadata;
        public String name;

        public RenderInfoBlock(Block block, int metadata, String name) {
            this.block = block;
            this.metadata = metadata;
            this.name = name;
        }
    }
}

