/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.misc.GuiWeatherController;
import sonar.calculator.mod.common.containers.ContainerWeatherController;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.machines.IProcessMachine;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.utils.IByteBufTile;

public class TileEntityWeatherController
extends TileEntityEnergyInventory
implements IByteBufTile,
IProcessMachine,
IFlexibleGui {
    public int type;
    public int data;
    public int buffer;
    public int coolDown;
    public static final int TIME = 0;
    public static final int RAIN = 1;
    public static final int THUNDER = 2;

    public TileEntityWeatherController() {
        this.inv.setSize(1);
        this.inv.getInsertFilters().put(SlotHelper.dischargeSlot((int)0), EnumFilterType.INTERNAL);
        this.storage.setCapacity(CalculatorConfig.WEATHER_CONTROLLER_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.WEATHER_CONTROLLER_TRANSFER_RATE);
        this.energyMode = EnergyMode.RECIEVE;
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.startProcess();
        this.discharge(0);
        if (this.buffer > 0) {
            this.storage.modifyEnergyStored(-(CalculatorConfig.WEATHER_CONTROLLER_USAGE / 100));
            if (this.buffer != 100) {
                ++this.buffer;
            } else {
                this.coolDown = 1;
                this.buffer = 0;
                if (!this.field_145850_b.field_72995_K) {
                    this.processType(this.type, false);
                }
            }
        }
        if (this.coolDown > 0) {
            this.coolDown = this.coolDown != 30 ? ++this.coolDown : 0;
        }
    }

    public void startProcess() {
        boolean power = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (this.buffer == 0 && this.coolDown == 0 && this.storage.getEnergyStored() >= CalculatorConfig.WEATHER_CONTROLLER_USAGE && this.processType(this.type, true) && (power || this.field_145850_b.func_175687_A(this.field_174879_c) > 0)) {
            this.buffer = 1;
        }
    }

    public boolean processType(int type, boolean simulate) {
        switch (type) {
            case 0: {
                if (this.data == 0 && this.field_145850_b.func_72935_r()) {
                    return false;
                }
                if (this.data > 0 && !this.field_145850_b.func_72935_r()) {
                    return false;
                }
                if (!simulate) {
                    long i = this.field_145850_b.func_72820_D() + 24000L;
                    long newTime = i - i % 24000L;
                    long oldTime = this.field_145850_b.func_72820_D();
                    if (this.data == 0) {
                        this.field_145850_b.func_72877_b(newTime);
                    } else {
                        this.field_145850_b.func_72877_b(newTime - 12000L > oldTime ? newTime - 12000L : oldTime + 12000L);
                    }
                }
                return true;
            }
            case 1: {
                if (this.data == 0 && !this.field_145850_b.func_72896_J()) {
                    return false;
                }
                if (this.data > 0 && this.field_145850_b.func_72896_J()) {
                    return false;
                }
                if (!simulate) {
                    this.field_145850_b.func_72912_H().func_76084_b(this.data != 0);
                }
                return true;
            }
            case 2: {
                if (this.data == 0 && !this.field_145850_b.func_72911_I()) {
                    return false;
                }
                if (this.data > 0 && this.field_145850_b.func_72911_I()) {
                    return false;
                }
                if (!simulate) {
                    this.field_145850_b.func_72912_H().func_76084_b(this.data != 0);
                    this.field_145850_b.func_72912_H().func_76069_a(this.data != 0);
                }
                return true;
            }
        }
        return false;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC})) {
            this.type = nbt.func_74762_e("type");
            this.data = nbt.func_74762_e("data");
            this.buffer = nbt.func_74762_e("buffer");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC})) {
            nbt.func_74768_a("type", this.type);
            nbt.func_74768_a("data", this.data);
            nbt.func_74768_a("buffer", this.buffer);
        }
        return nbt;
    }

    public void writePacket(ByteBuf buf, int id) {
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            this.data = this.data == 1 ? 0 : 1;
        } else {
            this.setType(id - 1);
        }
    }

    public int getCurrentProcessTime() {
        return this.buffer;
    }

    public int getProcessTime() {
        return 100;
    }

    public double getEnergyUsage() {
        return CalculatorConfig.WEATHER_CONTROLLER_USAGE / this.getProcessTime();
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerWeatherController(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiWeatherController(player.field_71071_by, this);
    }

    public int getBaseProcessTime() {
        return this.getProcessTime();
    }
}

