/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.machines.GuiDockingStation;
import sonar.calculator.mod.common.containers.ContainerDockingStation;
import sonar.calculator.mod.common.recipes.AtomicCalculatorRecipes;
import sonar.calculator.mod.common.recipes.CalculatorRecipes;
import sonar.calculator.mod.common.recipes.FlawlessCalculatorRecipes;
import sonar.calculator.mod.common.recipes.ScientificRecipes;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.core.api.inventories.IAdditionalInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.recipes.RecipeHelperV2;

public class TileEntityDockingStation
extends TileEntityAbstractProcess
implements IAdditionalInventory {
    public ItemStack calcStack = ItemStack.field_190927_a;

    public TileEntityDockingStation() {
        super(4, 1, CalculatorConfig.DOCKING_STATION_SPEED, CalculatorConfig.DOCKING_STATION_USAGE);
        this.storage.setCapacity(CalculatorConfig.DOCKING_STATION_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.DOCKING_STATION_TRANSFER_RATE);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> SonarHelper.intContains((int[])this.getSlotConfig(FACE), (int)SLOT), EnumFilterType.EXTERNAL);
    }

    public int[] getSlotConfig(EnumFacing side) {
        int[] outputSlot = new int[]{5};
        int[] emptySlot = new int[]{};
        int size = TileEntityDockingStation.getInputStackSize(this.calcStack);
        EnumFacing dir = EnumFacing.func_82600_a((int)this.func_145832_p());
        if (size == 0) {
            return emptySlot;
        }
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            return outputSlot;
        }
        if (size != 1) {
            if (side == SonarHelper.getHorizontal((EnumFacing)dir)) {
                return new int[]{0};
            }
            if (side == SonarHelper.getHorizontal((EnumFacing)dir).func_176734_d()) {
                return new int[]{1};
            }
            if ((size == 4 || size == 3) && side == dir.func_176734_d()) {
                return new int[]{2};
            }
            if (size == 4 && side == dir) {
                return new int[]{3};
            }
        }
        return outputSlot;
    }

    @Override
    public int inputSize() {
        return 4;
    }

    @Override
    public int outputSize() {
        return 1;
    }

    public static int getInputStackSize(ItemStack itemstack1) {
        if (!itemstack1.func_190926_b()) {
            return ProcessType.getType((Item)itemstack1.func_77973_b()).inputStacks;
        }
        return 0;
    }

    @Override
    public RecipeHelperV2 recipeHelper() {
        if (!this.calcStack.func_190926_b()) {
            return ProcessType.getType(this.calcStack.func_77973_b()).getRecipeHelper();
        }
        return CalculatorRecipes.instance();
    }

    @Override
    public int getProcessTime() {
        return Math.max(1, super.getProcessTime() / 8);
    }

    @Override
    public int requiredEnergy() {
        return 10;
    }

    @Override
    public ItemStack[] inputStacks() {
        int size = TileEntityDockingStation.getInputStackSize(this.calcStack);
        if (size == 0) {
            return null;
        }
        ItemStack[] input = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            input[i] = (ItemStack)this.slots().get(i);
        }
        return input;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.calcStack = new ItemStack(nbt.func_74775_l("calcStack"));
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE}) && this.calcStack != null) {
            NBTTagCompound stack = new NBTTagCompound();
            this.calcStack.func_77955_b(stack);
            nbt.func_74782_a("calcStack", (NBTBase)stack);
        }
        return nbt;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots().set(i, itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
    }

    public int convertMeta(int meta) {
        EnumFacing dir = EnumFacing.func_82600_a((int)meta);
        if (meta <= 1) {
            meta = 5;
        } else if ((meta & 5) <= 1) {
            meta = 2;
        }
        return meta;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerDockingStation(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiDockingStation(player.field_71071_by, this);
    }

    @Override
    public ItemStack[] getAdditionalStacks() {
        if (!this.calcStack.func_190926_b()) {
            return new ItemStack[]{this.calcStack};
        }
        return new ItemStack[0];
    }

    public static enum ProcessType {
        NONE(0),
        CALCULATOR(2),
        SCIENTIFIC(2),
        ATOMIC(3),
        FLAWLESS(4);

        public int inputStacks;

        private ProcessType(int inputStacks) {
            this.inputStacks = inputStacks;
        }

        public RecipeHelperV2 getRecipeHelper() {
            switch (this) {
                case ATOMIC: {
                    return AtomicCalculatorRecipes.instance();
                }
                case CALCULATOR: {
                    return CalculatorRecipes.instance();
                }
                case FLAWLESS: {
                    return FlawlessCalculatorRecipes.instance();
                }
                case SCIENTIFIC: {
                    return ScientificRecipes.instance();
                }
            }
            return null;
        }

        public Item getItem() {
            switch (this) {
                case ATOMIC: {
                    return Item.func_150898_a((Block)Calculator.atomicCalculator);
                }
                case CALCULATOR: {
                    return Calculator.itemCalculator;
                }
                case FLAWLESS: {
                    return Calculator.itemFlawlessCalculator;
                }
                case SCIENTIFIC: {
                    return Calculator.itemScientificCalculator;
                }
            }
            return null;
        }

        public static ProcessType getType(Item item) {
            for (ProcessType type : ProcessType.values()) {
                if (type.getItem() != item) continue;
                return type;
            }
            return NONE;
        }
    }
}

