/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.machines.GuiAtomicMultiplier;
import sonar.calculator.mod.common.containers.ContainerAtomicMultiplier;
import sonar.calculator.mod.utils.AtomicMultiplierBlacklist;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.machines.IProcessMachine;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.SlotFilter;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;

public class TileEntityAtomicMultiplier
extends TileEntityEnergyInventory
implements IProcessMachine,
IFlexibleGui {
    public static final SlotFilter input_slot = new SlotFilter(null, new int[]{0}, new EnumFacing[]{EnumFacing.UP});
    public static final SlotFilter circuit_slots = new SlotFilter(null, new int[]{1, 2, 3, 4, 5, 6, 7}, new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST});
    public SyncTagType.INT cookTime = new SyncTagType.INT(0);
    public SyncTagType.INT active = new SyncTagType.INT(1);

    public TileEntityAtomicMultiplier() {
        this.storage.setCapacity(CalculatorConfig.ATOMIC_MULTIPLIER_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.ATOMIC_MULTIPLIER_TRANSFER_RATE);
        this.inv.setSize(10);
        this.inv.getInsertFilters().put(input_slot, EnumFilterType.EXTERNAL);
        this.inv.getInsertFilters().put(circuit_slots, EnumFilterType.EXTERNAL);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> circuit_slots.checkSlot(SLOT) ? Boolean.valueOf(STACK.func_77973_b() == Calculator.circuitBoard) : null, EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> input_slot.checkSlot(SLOT) ? Boolean.valueOf(STACK.func_77976_d() >= 4 && TileEntityAtomicMultiplier.isAllowed(STACK)) : null, EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.dischargeSlot((int)9), EnumFilterType.INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.blockSlot((int)8), EnumFilterType.INTERNAL);
        this.inv.getExtractFilters().put((SLOT, COUNT, FACE) -> SLOT == 8, EnumFilterType.EXTERNAL);
        this.energyMode = EnergyMode.RECIEVE;
        this.CHARGING_RATE = CalculatorConfig.ATOMIC_MULTIPLIER_TRANSFER_RATE;
        this.syncList.addParts(new IDirtyPart[]{this.cookTime, this.active});
    }

    public void func_73660_a() {
        int energy;
        super.func_73660_a();
        this.discharge(9);
        if ((Integer)this.cookTime.getObject() > 0) {
            this.active.setObject((Object)1);
            this.cookTime.increaseBy(1);
            energy = CalculatorConfig.ATOMIC_MULTIPLIER_USAGE / CalculatorConfig.ATOMIC_MULTIPLIER_SPEED;
            this.storage.modifyEnergyStored(-energy);
        }
        if (this.canCook()) {
            if (!this.field_145850_b.field_72995_K && (Integer)this.cookTime.getObject() == 0) {
                this.cookTime.increaseBy(1);
            }
            if ((Integer)this.cookTime.getObject() >= CalculatorConfig.ATOMIC_MULTIPLIER_SPEED) {
                this.cookTime.setObject((Object)0);
                this.cookItem();
                this.active.setObject((Object)0);
                energy = CalculatorConfig.ATOMIC_MULTIPLIER_USAGE / CalculatorConfig.ATOMIC_MULTIPLIER_SPEED;
                this.storage.modifyEnergyStored(-energy);
                this.markBlockForUpdate();
            }
        } else if ((Integer)this.cookTime.getObject() != 0 || (Integer)this.active.getObject() != 0) {
            this.cookTime.setObject((Object)0);
            this.active.setObject((Object)0);
            this.markBlockForUpdate();
        }
        this.func_70296_d();
    }

    public boolean canCook() {
        if (this.storage.getEnergyStored() == 0) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (!((ItemStack)this.slots().get(i)).func_190926_b()) continue;
            return false;
        }
        if (!TileEntityAtomicMultiplier.isAllowed((ItemStack)this.slots().get(0))) {
            return false;
        }
        ItemStack output = (ItemStack)this.slots().get(8);
        if (!output.func_190926_b()) {
            if (output.func_190916_E() + 4 > 64) {
                return false;
            }
            if (!((ItemStack)this.slots().get(0)).func_77969_a(output)) {
                return false;
            }
        }
        if ((Integer)this.cookTime.getObject() == 0 && this.storage.getEnergyStored() < CalculatorConfig.ATOMIC_MULTIPLIER_USAGE) {
            return false;
        }
        if (((ItemStack)this.slots().get(0)).func_77976_d() < 4) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (((ItemStack)this.slots().get(i)).func_77973_b() == Calculator.circuitBoard) continue;
            return false;
        }
        if ((Integer)this.cookTime.getObject() >= CalculatorConfig.ATOMIC_MULTIPLIER_SPEED) {
            return true;
        }
        return true;
    }

    public static boolean isAllowed(ItemStack stack) {
        return AtomicMultiplierBlacklist.blacklist().isAllowed(stack.func_77973_b());
    }

    private void cookItem() {
        ItemStack itemstack = new ItemStack(((ItemStack)this.slots().get(0)).func_77973_b(), 4, ((ItemStack)this.slots().get(0)).func_77952_i());
        ItemStack output = (ItemStack)this.slots().get(8);
        if (output.func_190926_b()) {
            this.slots().set(8, itemstack);
        } else if (output.func_77969_a(itemstack)) {
            output.func_190917_f(4);
        }
        for (int i = 0; i < 8; ++i) {
            ((ItemStack)this.slots().get(i)).func_190918_g(1);
        }
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.markBlockForUpdate();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        super.getWailaInfo(currenttip, state);
        if ((Integer)this.cookTime.getObject() > 0) {
            String active = FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"locator.active");
            currenttip.add(active);
        } else {
            String idle = FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"locator.idle");
            currenttip.add(idle);
        }
        return currenttip;
    }

    public int getCurrentProcessTime() {
        return (Integer)this.cookTime.getObject();
    }

    public int getProcessTime() {
        return CalculatorConfig.ATOMIC_MULTIPLIER_SPEED;
    }

    public double getEnergyUsage() {
        return CalculatorConfig.ATOMIC_MULTIPLIER_USAGE / CalculatorConfig.ATOMIC_MULTIPLIER_SPEED;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerAtomicMultiplier(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiAtomicMultiplier(player.field_71071_by, this);
    }

    public int getBaseProcessTime() {
        return CalculatorConfig.ATOMIC_MULTIPLIER_SPEED;
    }
}

