/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.items.ILocatorModule;
import sonar.calculator.mod.api.machines.ICalculatorLocator;
import sonar.calculator.mod.client.gui.generators.GuiCalculatorLocator;
import sonar.calculator.mod.common.block.generators.CalculatorLocator;
import sonar.calculator.mod.common.containers.ContainerCalculatorLocator;
import sonar.calculator.mod.common.tileentity.generators.TileEntityCalculatorPlug;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;

public class TileEntityCalculatorLocator
extends TileEntityEnergyInventory
implements IByteBufTile,
ICalculatorLocator,
IFlexibleGui {
    public SyncTagType.BOOLEAN active = new SyncTagType.BOOLEAN(0);
    public SyncTagType.INT size = new SyncTagType.INT(1);
    public SyncTagType.INT stability = new SyncTagType.INT(2);
    public SyncTagType.STRING owner = (SyncTagType.STRING)new SyncTagType.STRING(3).setDefault((Object)"None");
    public SyncTagType.INT currentGen = new SyncTagType.INT(4);
    private int sizeTicks;
    private int luckTicks;

    public TileEntityCalculatorLocator() {
        this.storage.setCapacity(CalculatorConfig.CALCULATOR_LOCATOR_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.CALCULATOR_LOCATOR_TRANSFER_RATE);
        this.CHARGING_RATE = CalculatorConfig.CALCULATOR_LOCATOR_CHARGING_RATE;
        this.inv.setSize(2);
        this.inv.getInsertFilters().put(SlotHelper.chargeSlot((int)0), EnumFilterType.INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)1, s -> s.func_77973_b() instanceof ILocatorModule), EnumFilterType.EXTERNAL_INTERNAL);
        this.energyMode = EnergyMode.SEND;
        this.syncList.addParts(new IDirtyPart[]{this.active, this.size, this.stability, this.owner, this.currentGen});
    }

    public void func_73660_a() {
        super.func_73660_a();
        boolean flag = (Boolean)this.active.getObject();
        boolean invert = false;
        if (this.canGenerate()) {
            if (this.isServer()) {
                this.beginGeneration();
            }
            if (!((Boolean)this.active.getObject()).booleanValue()) {
                invert = true;
            }
        } else if (((Boolean)this.active.getObject()).booleanValue()) {
            invert = true;
        }
        if (this.isServer()) {
            if (invert) {
                this.active.invert();
            }
            if (this.sizeTicks < 25) {
                ++this.sizeTicks;
            } else {
                this.sizeTicks = 0;
                this.createStructure();
                this.getStability();
            }
            if (flag != (Boolean)this.active.getObject()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)CalculatorLocator.ACTIVE, (Comparable)this.active.getObject()), 2);
                SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)1);
            }
            this.charge(0);
            this.addEnergy(new EnumFacing[]{EnumFacing.DOWN});
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int currentOutput() {
        int size = (Integer)this.size.getObject();
        if (size != 0 && (2 * size + 1) * (2 * size + 1) - 1 != 0) {
            int stable = (Integer)this.stability.getObject() * 100 / ((2 * size + 1) * (2 * size + 1));
            return (int)((float)(5 + (int)(1000.0 * Math.sqrt((double)size * 1.8) - 100.0 * Math.sqrt(100 - stable)) / (int)(11.0 - Math.sqrt(stable)) * size) * CalculatorConfig.CALCULATOR_LOCATOR_MULTIPLIER);
        }
        return 0;
    }

    public void getStability() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int currentStable = 0;
        if ((Integer)this.size.getObject() == 0) {
            this.stability.setObject((Object)0);
        }
        for (int Z = -((Integer)this.size.getObject()).intValue(); Z <= (Integer)this.size.getObject(); ++Z) {
            for (int X = -((Integer)this.size.getObject()).intValue(); X <= (Integer)this.size.getObject(); ++X) {
                TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(X, 0, Z));
                if (!(target instanceof TileEntityCalculatorPlug)) continue;
                TileEntityCalculatorPlug plug = (TileEntityCalculatorPlug)target;
                currentStable += plug.getS();
            }
        }
        this.stability.setObject((Object)currentStable);
    }

    public boolean canGenerate() {
        if (this.storage.getEnergyStored() >= this.storage.getMaxEnergyStored() || (Integer)this.size.getObject() == 0) {
            return false;
        }
        if (this.isLocated()) {
            if ((Integer)this.stability.getObject() >= 7) {
                return true;
            }
            EntityPlayer player = this.field_145850_b.func_72924_a(this.getOwner());
            return player != null;
        }
        return false;
    }

    public void beginGeneration() {
        this.currentGen.setObject((Object)this.currentOutput());
        this.storage.modifyEnergyStored(((Integer)this.currentGen.getObject()).intValue());
        if (!this.field_145850_b.field_72995_K) {
            if (this.luckTicks >= 0 && this.luckTicks != 50) {
                ++this.luckTicks;
            } else if (this.luckTicks == 50) {
                this.luckTicks = 0;
                this.effectStart();
            }
            if (CalculatorConfig.CALCULATOR_LOCATOR_CAN_CHANGE_TIME && (Integer)this.stability.getObject() * 4 < 20) {
                this.timeStart();
            }
        }
    }

    private void timeStart() {
        this.field_145850_b.func_72877_b(this.field_145850_b.func_72820_D() + 100L);
    }

    public void addItem(EntityPlayer player, Item item) {
        player.field_71071_by.func_70441_a(new ItemStack(item));
    }

    public void addPotion(EntityPlayer player, String potionID) {
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)potionID), 1000, 1));
    }

    private void effectStart() {
        EntityPlayer player = this.field_145850_b.func_72924_a(this.getOwner());
        if (player != null) {
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            int stability = (Integer)this.stability.getObject();
            int luck = 1 + (int)(Math.random() * (double)(20 * (stability + 1) - 1 + 20 * (stability + 1)));
            if (stability == 0) {
                this.field_145850_b.func_72876_a((Entity)player, x, y, z, 4.0f, true);
                player.func_70606_j(player.func_110143_aJ() - 4.0f);
            } else {
                if (stability < 2) {
                    switch (luck) {
                        case 1: {
                            this.field_145850_b.func_72876_a((Entity)player, x, y, z, 4.0f, true);
                            player.func_70606_j(player.func_110143_aJ() - 4.0f);
                        }
                    }
                }
                if (stability < 4) {
                    switch (luck) {
                        case 2: {
                            player.func_70015_d(400);
                            break;
                        }
                        case 3: {
                            this.field_145850_b.func_72876_a((Entity)player, x, y, z, 8.0f, true);
                            break;
                        }
                        case 4: {
                            this.field_145850_b.func_72876_a((Entity)player, x, y, z, 6.0f, true);
                            break;
                        }
                        case 5: {
                            this.addPotion(player, "nausea");
                            break;
                        }
                        case 6: {
                            this.addPotion(player, "blindness");
                        }
                    }
                }
                if (stability < 6) {
                    switch (luck) {
                        case 7: {
                            this.addItem(player, Calculator.grenade);
                            break;
                        }
                        case 8: {
                            this.addItem(player, Calculator.itemScientificCalculator);
                            break;
                        }
                        case 9: {
                            this.addItem(player, Calculator.itemCalculator);
                            break;
                        }
                        case 10: {
                            this.addPotion(player, "jump_boost");
                            break;
                        }
                        case 11: {
                            this.addPotion(player, "water_breathing");
                            break;
                        }
                        case 12: {
                            this.addPotion(player, "slowness");
                            break;
                        }
                        case 13: {
                            this.addPotion(player, "strength");
                        }
                    }
                }
                if (stability < 7) {
                    switch (luck) {
                        case 14: {
                            this.addPotion(player, "wither");
                            break;
                        }
                        case 15: {
                            this.addItem(player, Items.field_151117_aB);
                            break;
                        }
                        case 16: {
                            int luck2 = 1 + (int)(Math.random() * 4.0 + 5.0);
                            if (luck2 != 16) break;
                            this.field_145850_b.func_72876_a((Entity)player, x, y, z, 80.0f, true);
                            player.func_70606_j(player.func_110143_aJ() - 40.0f);
                        }
                    }
                }
            }
        }
    }

    protected boolean isLocated() {
        ItemStack stack = this.func_70301_a(1);
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ILocatorModule) {
            String name = ((ILocatorModule)stack.func_77973_b()).getPlayer(stack);
            return name != null && !name.equals("None");
        }
        return false;
    }

    public void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        if (slot == 1) {
            this.createOwner();
        }
    }

    public void createOwner() {
        String name;
        ItemStack stack = this.func_70301_a(1);
        if (stack.func_190926_b()) {
            this.owner.setObject((Object)"None");
            return;
        }
        if (stack.func_77973_b() instanceof ILocatorModule && (name = ((ILocatorModule)stack.func_77973_b()).getPlayer(stack)) != null) {
            this.owner.setObject((Object)name);
        }
    }

    public void createStructure() {
        int size = CalculatorLocator.multiBlockStructure(this.func_145831_w(), this.field_174879_c);
        if (size != (Integer)this.size.getObject()) {
            this.size.setObject((Object)size);
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.luckTicks = nbt.func_74762_e("ticks");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74768_a("ticks", this.luckTicks);
        }
        return nbt;
    }

    public EnergyMode getModeForSide(EnumFacing side) {
        if (side == null) {
            return EnergyMode.SEND_RECIEVE;
        }
        if (side == EnumFacing.DOWN) {
            return EnergyMode.SEND;
        }
        return EnergyMode.BLOCKED;
    }

    public boolean maxRender() {
        return true;
    }

    public int beamHeight() {
        boolean f = false;
        for (int i = 1; i <= 256; ++i) {
            if (!this.field_145850_b.isSideSolid(this.field_174879_c.func_177982_a(0, i, 0), EnumFacing.UP)) continue;
            return i;
        }
        return 256;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        currenttip.add(FontHelper.translate((String)"locator.active") + ": " + ((Boolean)state.func_177229_b((IProperty)CalculatorLocator.ACTIVE) == false ? FontHelper.translate((String)"locator.false") : FontHelper.translate((String)"locator.true")));
        currenttip.add(FontHelper.translate((String)"locator.owner") + ": " + (!((String)this.owner.getObject()).equals("None") ? (String)this.owner.getObject() : FontHelper.translate((String)"locator.none")));
        return currenttip;
    }

    public void onFirstTick() {
        super.onFirstTick();
        this.createOwner();
        this.createStructure();
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 0) {
            this.active.writeToBuf(buf);
        }
        if (id == 1) {
            this.size.writeToBuf(buf);
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            this.active.readFromBuf(buf);
            this.markBlockForUpdate();
        }
        if (id == 1) {
            this.size.readFromBuf(buf);
        }
    }

    @Override
    public String getOwner() {
        return (String)this.owner.getObject();
    }

    @Override
    public int getSize() {
        return (Integer)this.size.getObject();
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.active.getObject();
    }

    @Override
    public double getStabilityPercent() {
        return (Integer)this.stability.getObject() * 100 / ((2 * (Integer)this.size.getObject() + 1) * (2 * (Integer)this.size.getObject() + 1) - 1);
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerCalculatorLocator(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiCalculatorLocator(player.field_71071_by, this);
    }
}

