/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.misc;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.api.items.IStability;
import sonar.core.SonarCore;
import sonar.core.api.utils.ICalculatorCircuit;
import sonar.core.common.item.SonarMetaItem;
import sonar.core.helpers.FontHelper;

public class CircuitBoard
extends SonarMetaItem
implements IStability,
ICalculatorCircuit {
    public CircuitBoard() {
        super(14);
    }

    public static CircuitState getState(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof CircuitBoard && stack.func_77942_o() && stack.func_77978_p().func_74767_n("Analysed")) {
            int stable = stack.func_77978_p().func_74762_e("Stable");
            return stable == 1 ? CircuitState.STABLE : CircuitState.ANALYSED;
        }
        return CircuitState.NOT_ANALYSED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(stack, world, list, par4);
        CircuitState state = CircuitBoard.getState(stack);
        if (state.suffix.isEmpty()) {
            list.add(FontHelper.translate((String)state.translate));
        } else {
            list.add(state.suffix + ": " + FontHelper.translate((String)state.translate));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack) + CircuitBoard.getState((ItemStack)stack).suffix;
    }

    public static void setData(ItemStack stack) {
        NBTTagCompound nbtData = stack.func_77978_p();
        if (nbtData == null) {
            nbtData = new NBTTagCompound();
            nbtData.func_74768_a("Energy", SonarCore.randInt((int)1, (int)200));
            nbtData.func_74768_a("Item1", SonarCore.randInt((int)1, (int)50));
            nbtData.func_74768_a("Item2", SonarCore.randInt((int)1, (int)100));
            nbtData.func_74768_a("Item3", SonarCore.randInt((int)1, (int)1000));
            nbtData.func_74768_a("Item4", SonarCore.randInt((int)1, (int)2000));
            nbtData.func_74768_a("Item5", SonarCore.randInt((int)1, (int)10000));
            nbtData.func_74768_a("Item6", SonarCore.randInt((int)1, (int)20000));
            nbtData.func_74768_a("Stable", SonarCore.randInt((int)1, (int)6));
            stack.func_77982_d(nbtData);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par, boolean bool) {
        super.func_77663_a(stack, world, entity, par, bool);
        if (stack.func_77978_p() == null && !stack.func_77942_o()) {
            CircuitBoard.setData(stack);
        }
    }

    @Override
    public boolean getStability(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e("Stable") == 1;
    }

    @Override
    public void onFalse(ItemStack stack) {
        stack.func_77978_p().func_74768_a("Stable", 0);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getStability(stack);
    }

    public static enum CircuitState {
        STABLE("circuit.stable", "A"),
        ANALYSED("circuit.analysed", "B"),
        NOT_ANALYSED("Not analysed", "");

        String translate;
        String suffix;

        private CircuitState(String translate, String suffix) {
            this.translate = translate;
            this.suffix = suffix;
        }
    }
}

