/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators.modules;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.modules.IModuleEnergy;
import sonar.core.api.utils.ActionType;

public class EnergyModule
implements IModuleEnergy {
    public boolean isLoadable() {
        return true;
    }

    public String getName() {
        return "Energy Module";
    }

    @Override
    public String getClientName(NBTTagCompound tag) {
        return this.getItemStack(tag).func_82833_r();
    }

    @Override
    public ItemStack getItemStack(NBTTagCompound tag) {
        Item item = (Item)Calculator.moduleItems.getPrimaryObject(this.getName());
        if (item != null) {
            ItemStack moduleStack = new ItemStack(item, 1);
            moduleStack.func_77982_d(tag);
            return moduleStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public long receiveEnergy(ItemStack container, NBTTagCompound tag, long maxReceive, ActionType action) {
        long energy = tag.func_74763_f("Energy");
        long energyReceived = Math.min(this.getMaxEnergyStored(container, tag) - energy, Math.min(this.getMaxEnergyStored(container, tag) / 10L, maxReceive));
        if (!action.shouldSimulate()) {
            tag.func_74772_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public long extractEnergy(ItemStack container, NBTTagCompound tag, long maxExtract, ActionType action) {
        if (!tag.func_74764_b("Energy")) {
            return 0L;
        }
        long energy = tag.func_74763_f("Energy");
        long energyExtracted = Math.min(energy, Math.min(this.getMaxEnergyStored(container, tag) / 10L, maxExtract));
        if (!action.shouldSimulate()) {
            tag.func_74772_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public long getEnergyStored(ItemStack container, NBTTagCompound tag) {
        return tag.func_74763_f("Energy");
    }

    @Override
    public long getMaxEnergyStored(ItemStack container, NBTTagCompound tag) {
        return CalculatorConfig.ENERGY_MODULE_STORAGE;
    }
}

