/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.gui.machines;

import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import sonar.calculator.mod.client.gui.buttons.CircuitButton;
import sonar.calculator.mod.client.gui.buttons.PauseButton;
import sonar.calculator.mod.common.containers.ContainerSmeltingBlock;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.core.client.gui.GuiSonarTile;
import sonar.core.client.gui.SonarButtons;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.IWorldPosition;

public class GuiSmeltingBlock
extends GuiSonarTile {
    public TileEntityAbstractProcess entity;

    public GuiSmeltingBlock(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
        super((Container)new ContainerSmeltingBlock(inventoryPlayer, entity), (IWorldPosition)entity);
        this.entity = entity;
    }

    public ResourceLocation getBackground() {
        return new ResourceLocation("Calculator:textures/gui/restorationchamber.png");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new CircuitButton(this, this.entity.getUpgradeInventory(), 0, this.field_147003_i + 150 - 14, this.field_147009_r + 23));
        this.field_146292_n.add(new PauseButton(this, this.entity, 1, this.field_147003_i + 8 + 14, this.field_147009_r + 23, () -> this.entity.isPaused()));
    }

    public void func_146979_b(int x, int y) {
        FontHelper.textCentre((String)this.entity.func_70005_c_(), (int)this.field_146999_f, (int)6, (int)0);
        FontHelper.textCentre((String)FontHelper.formatStorage((long)this.entity.storage.getEnergyStored()), (int)this.field_146999_f, (int)64, (int)2);
        if (x > this.field_147003_i + 130 && x < this.field_147003_i + 144 && y > this.field_147009_r + 60 && y < this.field_147009_r + 74) {
            ArrayList<String> list = new ArrayList<String>();
            DecimalFormat df = new DecimalFormat("#.##");
            list.add(TextFormatting.BLUE + "" + TextFormatting.UNDERLINE + "Machine Stats");
            list.add("Usage: " + df.format(this.entity.getEnergyUsage()) + " rf/t");
            list.add("Speed: " + this.entity.getProcessTime() + " ticks");
            list.add("Stored: " + this.entity.storage.getEnergyStored() + " RF");
            this.drawSpecialToolTip(list, x, y, this.field_146289_q);
        }
        super.func_146979_b(x, y);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        int k = this.entity.storage.getEnergyStored() * 78 / this.entity.storage.getMaxEnergyStored();
        int j = 78 - k;
        this.func_73729_b(this.field_147003_i + 49, this.field_147009_r + 63, 176, 0, k, 10);
        if (this.entity.currentSpeed != 0 && (Integer)this.entity.cookTime.getObject() != 0) {
            int l = (Integer)this.entity.cookTime.getObject() * 23 / this.entity.currentSpeed;
            this.func_73729_b(this.field_147003_i + 76, this.field_147009_r + 24, 176, 10, l, 16);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (this.entity.func_145831_w().field_72995_K && button instanceof SonarButtons.SonarButton) {
            SonarButtons.SonarButton sButton = (SonarButtons.SonarButton)button;
            sButton.onClicked();
        }
    }

    public static class ReinforcedFurnace
    extends GuiSmeltingBlock {
        public ReinforcedFurnace(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
            super(inventoryPlayer, entity);
        }

        @Override
        public ResourceLocation getBackground() {
            return new ResourceLocation("Calculator:textures/gui/reinforcedFurnace.png");
        }
    }

    public static class ProcessingChamber
    extends GuiSmeltingBlock {
        public ProcessingChamber(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
            super(inventoryPlayer, entity);
        }
    }

    public static class ReassemblyChamber
    extends GuiSmeltingBlock {
        public ReassemblyChamber(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
            super(inventoryPlayer, entity);
        }
    }

    public static class RestorationChamber
    extends GuiSmeltingBlock {
        public RestorationChamber(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
            super(inventoryPlayer, entity);
        }
    }
}

