/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Biomes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class Misc {
    public static Random random = new Random();

    public static boolean isExtremeHills(Biome biome) {
        return biome.func_185359_l().compareTo(Biomes.field_76770_e.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76783_v.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_150580_W.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185443_S.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185434_af.func_185359_l()) == 0;
    }

    public static EnumFacing getOppositeHorizontalFace(EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return EnumFacing.DOWN;
        }
        if (face == EnumFacing.UP) {
            return EnumFacing.UP;
        }
        return face.func_176734_d();
    }

    public static ItemStack getRepairItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemTool) {
            ItemStack mat = Item.ToolMaterial.valueOf((String)((ItemTool)stack.func_77973_b()).func_77861_e()).getRepairItemStack().func_77946_l();
            if (mat.func_77952_i() == Short.MAX_VALUE) {
                mat.func_77964_b(0);
            }
            return mat;
        }
        if (stack.func_77973_b() instanceof ItemSword) {
            ItemStack mat = Item.ToolMaterial.valueOf((String)((ItemSword)stack.func_77973_b()).func_150932_j()).getRepairItemStack().func_77946_l();
            if (mat.func_77952_i() == Short.MAX_VALUE) {
                mat.func_77964_b(0);
            }
            return mat;
        }
        if (stack.func_77973_b() instanceof ItemArmor) {
            ItemStack mat = ((ItemArmor)stack.func_77973_b()).func_82812_d().getRepairItemStack().func_77946_l();
            if (mat.func_77952_i() == Short.MAX_VALUE) {
                mat.func_77964_b(0);
            }
            return mat;
        }
        return ItemStack.field_190927_a;
    }

    public static List<TileEntity> getAdjacentTiles(World world, BlockPos pos) {
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        tiles.add(world.func_175625_s(pos.func_177984_a()));
        tiles.add(world.func_175625_s(pos.func_177977_b()));
        tiles.add(world.func_175625_s(pos.func_177976_e()));
        tiles.add(world.func_175625_s(pos.func_177974_f()));
        tiles.add(world.func_175625_s(pos.func_177978_c()));
        tiles.add(world.func_175625_s(pos.func_177968_d()));
        return tiles;
    }

    public static EntityItem rayTraceItem(World world, double posX, double posY, double posZ, double dirX, double dirY, double dirZ) {
        double x = posX;
        double y = posY;
        double z = posZ;
        for (int i = 0; i < 120; ++i) {
            List items;
            if ((items = world.func_72872_a(EntityItem.class, new AxisAlignedBB((x += dirX / 20.0) - 0.2, (y += dirY / 20.0) - 0.2, (z += dirZ / 20.0) - 0.2, x + 0.2, y + 0.2, z + 0.2))).size() <= 0) continue;
            return (EntityItem)items.get(0);
        }
        return null;
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static boolean matchOreDict(ItemStack stack1, ItemStack stack2) {
        int[] keys1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] keys2 = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i = 0; i < keys1.length; ++i) {
            for (int j = 0; j < keys2.length; ++j) {
                if (keys1[i] != keys2[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean betweenAngles(float angleTest, float angleLow, float angleHigh) {
        boolean between;
        boolean bl = between = angleTest >= angleLow && angleTest <= angleHigh;
        if (angleHigh < angleLow) {
            between = angleTest >= angleLow && angleTest < 360.0f || angleTest > 0.0f && angleTest <= angleHigh;
        }
        return between;
    }

    public static float yawDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        return f;
    }

    public static float pitchDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        return (float)Math.toDegrees(Math.atan2(posY2 - posY, Math.sqrt((posX2 - posX) * (posX2 - posX) + (posZ2 - posZ) * (posZ2 - posZ))));
    }

    public static EnumFacing getOppositeFace(EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return EnumFacing.UP;
        }
        if (face == EnumFacing.UP) {
            return EnumFacing.DOWN;
        }
        return face.func_176734_d();
    }

    public static int getResourceCount(ItemStack stack) {
        int baseCount = 0;
        if (stack.func_77973_b() instanceof ItemArmor) {
            if (((ItemArmor)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.HEAD) {
                baseCount = 5;
            }
            if (((ItemArmor)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.CHEST) {
                baseCount = 8;
            }
            if (((ItemArmor)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.LEGS) {
                baseCount = 7;
            }
            if (((ItemArmor)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.FEET) {
                baseCount = 4;
            }
        }
        if (stack.func_77973_b() instanceof ItemSword) {
            baseCount = 2;
        }
        if (stack.func_77973_b() instanceof ItemBow) {
            baseCount = 3;
        }
        if (stack.func_77973_b() instanceof ItemTool) {
            if (stack.func_77973_b() instanceof ItemPickaxe || stack.func_77973_b().getHarvestLevel(stack, "pickaxe", null, null) > -1) {
                baseCount = 3;
            }
            if (stack.func_77973_b() instanceof ItemAxe || stack.func_77973_b().getHarvestLevel(stack, "axe", null, null) > -1) {
                baseCount = 3;
            }
            if (stack.func_77973_b() instanceof ItemHoe) {
                baseCount = 2;
            }
            if (stack.func_77973_b() instanceof ItemSpade) {
                baseCount = 1;
            }
            baseCount = 1;
        }
        if (baseCount > 0) {
            return (int)((float)baseCount * (1.0f - (float)stack.func_77952_i() / (float)stack.func_77958_k()));
        }
        return -1;
    }

    public static EnumFacing getOppositeVerticalFace(EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return EnumFacing.UP;
        }
        if (face == EnumFacing.UP) {
            return EnumFacing.DOWN;
        }
        return face;
    }

    public static boolean isHills(Biome biome) {
        return biome.func_185359_l().compareTo(Biomes.field_150582_Q.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_150579_T.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76786_s.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76785_t.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76792_x.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185429_aa.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185433_ae.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_150581_V.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76784_u.func_185359_l()) == 0;
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i) == ItemStack.field_190927_a) continue;
                world.func_72838_d((Entity)new EntityItem(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }
}

