/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IItemPipePriority;
import teamroots.embers.tileentity.IPressurizable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityItemExtractor;
import teamroots.embers.util.Misc;

public class TileEntityItemPipe
extends TileEntity
implements ITileEntityBase,
ITickable,
IPressurizable {
    int ticksExisted = 0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityItemPipe.this.func_70296_d();
        }
    };
    public BlockPos lastReceived = new BlockPos(0, 0, 0);
    public int pressure = 0;
    Random random = new Random();
    public EnumPipeConnection up = EnumPipeConnection.NONE;
    public EnumPipeConnection down = EnumPipeConnection.NONE;
    public EnumPipeConnection north = EnumPipeConnection.NONE;
    public EnumPipeConnection south = EnumPipeConnection.NONE;
    public EnumPipeConnection east = EnumPipeConnection.NONE;
    public EnumPipeConnection west = EnumPipeConnection.NONE;
    public boolean dirty = false;

    public static EnumPipeConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumPipeConnection.NONE;
            }
            case 1: {
                return EnumPipeConnection.PIPE;
            }
            case 2: {
                return EnumPipeConnection.BLOCK;
            }
            case 3: {
                return EnumPipeConnection.LEVER;
            }
            case 4: {
                return EnumPipeConnection.FORCENONE;
            }
        }
        return EnumPipeConnection.NONE;
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.UP);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.DOWN);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("lastX", this.lastReceived.func_177958_n());
        tag.func_74768_a("lastY", this.lastReceived.func_177956_o());
        tag.func_74768_a("lastZ", this.lastReceived.func_177952_p());
        tag.func_74768_a("pressure", this.pressure);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityItemPipe.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityItemPipe.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityItemPipe.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityItemPipe.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityItemPipe.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityItemPipe.connectionFromInt(tag.func_74762_e("east"));
        this.lastReceived = new BlockPos(tag.func_74762_e("lastX"), tag.func_74762_e("lastY"), tag.func_74762_e("lastZ"));
        this.pressure = tag.func_74762_e("pressure");
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumPipeConnection getConnection(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return this.up;
        }
        if (side == EnumFacing.DOWN) {
            return this.down;
        }
        if (side == EnumFacing.EAST) {
            return this.east;
        }
        if (side == EnumFacing.WEST) {
            return this.west;
        }
        if (side == EnumFacing.NORTH) {
            return this.north;
        }
        if (side == EnumFacing.SOUTH) {
            return this.south;
        }
        return EnumPipeConnection.NONE;
    }

    public void setConnection(EnumFacing side, EnumPipeConnection connect) {
        if (side == EnumFacing.UP) {
            this.up = connect;
        } else if (side == EnumFacing.DOWN) {
            this.down = connect;
        } else if (side == EnumFacing.EAST) {
            this.east = connect;
        } else if (side == EnumFacing.WEST) {
            this.west = connect;
        } else if (side == EnumFacing.NORTH) {
            this.north = connect;
        } else if (side == EnumFacing.SOUTH) {
            this.south = connect;
        }
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.getConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.FORCENONE;
        }
        if (tile instanceof TileEntityItemPipe) {
            return EnumPipeConnection.PIPE;
        }
        if (tile instanceof TileEntityItemExtractor) {
            return EnumPipeConnection.BLOCK;
        }
        if (tile != null && world.func_175625_s(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Misc.getOppositeFace(side))) {
            return EnumPipeConnection.BLOCK;
        }
        return EnumPipeConnection.NONE;
    }

    public void reverseConnection(EnumFacing face) {
    }

    public static EnumPipeConnection reverseForce(EnumPipeConnection connect) {
        if (connect == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NONE;
        }
        if (connect != EnumPipeConnection.NONE && connect != EnumPipeConnection.LEVER) {
            return EnumPipeConnection.FORCENONE;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a && heldItem.func_77973_b() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.west = TileEntityItemPipe.reverseForce(this.west);
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.east = TileEntityItemPipe.reverseForce(this.east);
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.north = TileEntityItemPipe.reverseForce(this.north);
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.south = TileEntityItemPipe.reverseForce(this.south);
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.down = TileEntityItemPipe.reverseForce(this.down);
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.up = TileEntityItemPipe.reverseForce(this.up);
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.north = TileEntityItemPipe.reverseForce(this.north);
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.south = TileEntityItemPipe.reverseForce(this.south);
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.west = TileEntityItemPipe.reverseForce(this.west);
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.east = TileEntityItemPipe.reverseForce(this.east);
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.down = TileEntityItemPipe.reverseForce(this.down);
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.up = TileEntityItemPipe.reverseForce(this.up);
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public boolean isConnected(EnumFacing face) {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
        if (tile instanceof TileEntityItemPipe && ((TileEntityItemPipe)tile).getConnection(Misc.getOppositeFace(face)) != EnumPipeConnection.FORCENONE && ((TileEntityItemPipe)tile).getConnection(Misc.getOppositeFace(face)) != EnumPipeConnection.NONE) {
            return true;
        }
        if (tile instanceof TileEntityItemExtractor && ((TileEntityItemExtractor)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityItemExtractor.EnumPipeConnection.FORCENONE && ((TileEntityItemExtractor)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityItemExtractor.EnumPipeConnection.NONE) {
            return true;
        }
        return this.getConnection(face) == EnumPipeConnection.BLOCK;
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.ticksExisted % 1 == 0 && !this.field_145850_b.field_72995_K) {
            TileEntity tile;
            ItemStack extracted;
            int slot;
            ItemStack passStack;
            IItemHandler handler;
            TileEntity tile2;
            EnumFacing face;
            int i;
            ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
            ArrayList<EnumFacing> connections = new ArrayList<EnumFacing>();
            if (this.up != EnumPipeConnection.NONE && this.up != EnumPipeConnection.FORCENONE && this.up != EnumPipeConnection.LEVER && this.isConnected(EnumFacing.UP)) {
                connections.add(EnumFacing.UP);
            }
            if (this.down != EnumPipeConnection.NONE && this.down != EnumPipeConnection.FORCENONE && this.down != EnumPipeConnection.LEVER && this.isConnected(EnumFacing.DOWN)) {
                connections.add(EnumFacing.DOWN);
            }
            if (this.north != EnumPipeConnection.NONE && this.north != EnumPipeConnection.FORCENONE && this.north != EnumPipeConnection.LEVER && this.isConnected(EnumFacing.NORTH)) {
                connections.add(EnumFacing.NORTH);
            }
            if (this.south != EnumPipeConnection.NONE && this.south != EnumPipeConnection.FORCENONE && this.south != EnumPipeConnection.LEVER && this.isConnected(EnumFacing.SOUTH)) {
                connections.add(EnumFacing.SOUTH);
            }
            if (this.east != EnumPipeConnection.NONE && this.east != EnumPipeConnection.FORCENONE && this.east != EnumPipeConnection.LEVER && this.isConnected(EnumFacing.EAST)) {
                connections.add(EnumFacing.EAST);
            }
            if (this.west != EnumPipeConnection.NONE && this.west != EnumPipeConnection.FORCENONE && this.west != EnumPipeConnection.LEVER && this.isConnected(EnumFacing.WEST)) {
                connections.add(EnumFacing.WEST);
            }
            for (int i2 = 0; i2 < connections.size(); ++i2) {
                if (this.func_174877_v().func_177972_a((EnumFacing)connections.get(i2)).func_177958_n() != this.lastReceived.func_177958_n() || this.func_174877_v().func_177972_a((EnumFacing)connections.get(i2)).func_177956_o() != this.lastReceived.func_177956_o() || this.func_174877_v().func_177972_a((EnumFacing)connections.get(i2)).func_177952_p() != this.lastReceived.func_177952_p()) continue;
                connections.remove(i2);
                i2 = Math.max(0, i2 - 1);
            }
            ArrayList priorities = new ArrayList();
            for (i = 0; i < connections.size(); ++i) {
                if (!(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connections.get(i))) instanceof IItemPipePriority)) continue;
                priorities.add(connections.get(i));
            }
            if (priorities.size() > 0) {
                if (this.lastReceived.func_177958_n() != 0 || this.lastReceived.func_177956_o() != 0 || this.lastReceived.func_177952_p() != 0) {
                    for (i = 0; i < 1; ++i) {
                        ItemStack added;
                        if (this.inventory.getStackInSlot(0).func_190926_b()) continue;
                        face = (EnumFacing)priorities.get(this.random.nextInt(priorities.size()));
                        tile2 = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
                        if (tile2 == null || !tile2.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) || (handler = (IItemHandler)tile2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) == null) continue;
                        passStack = new ItemStack(this.inventory.getStackInSlot(0).func_77973_b(), 1, this.inventory.getStackInSlot(0).func_77960_j());
                        if (this.inventory.getStackInSlot(0).func_77942_o()) {
                            passStack.func_77982_d(this.inventory.getStackInSlot(0).func_77978_p());
                        }
                        slot = -1;
                        for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
                            if (handler.getStackInSlot(j).func_190926_b()) {
                                slot = j;
                                continue;
                            }
                            if (handler.getStackInSlot(j).func_190916_E() >= handler.getSlotLimit(j) || !ItemStack.func_179545_c((ItemStack)handler.getStackInSlot(j), (ItemStack)this.inventory.getStackInSlot(0)) || !ItemStack.func_77970_a((ItemStack)handler.getStackInSlot(j), (ItemStack)this.inventory.getStackInSlot(0))) continue;
                            slot = j;
                        }
                        if (slot == -1 || !(added = handler.insertItem(slot, passStack, false)).func_190926_b() || (extracted = this.inventory.extractItem(0, 1, false)).func_190926_b()) continue;
                        if (tile2 instanceof TileEntityItemPipe) {
                            ((TileEntityItemPipe)tile2).lastReceived = this.func_174877_v();
                        }
                        if (!toUpdate.contains(this.func_174877_v().func_177972_a(face))) {
                            toUpdate.add(this.func_174877_v().func_177972_a(face));
                        }
                        if (toUpdate.contains(this.func_174877_v())) continue;
                        toUpdate.add(this.func_174877_v());
                    }
                }
                for (i = 0; i < toUpdate.size(); ++i) {
                    tile = this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i));
                    tile.func_70296_d();
                    if (this.func_145831_w().field_72995_K || tile instanceof ITileEntityBase) continue;
                    tile.func_70296_d();
                    EventManager.markTEForUpdate((BlockPos)toUpdate.get(i), tile);
                }
                if (toUpdate.size() > 0) {
                    return;
                }
            }
            if (connections.size() > 0) {
                if (this.lastReceived.func_177958_n() != 0 || this.lastReceived.func_177956_o() != 0 || this.lastReceived.func_177952_p() != 0) {
                    for (i = 0; i < 1; ++i) {
                        ItemStack added;
                        if (this.inventory.getStackInSlot(0).func_190926_b()) continue;
                        face = (EnumFacing)connections.get(this.random.nextInt(connections.size()));
                        tile2 = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
                        if (tile2 == null || !tile2.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) || (handler = (IItemHandler)tile2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) == null) continue;
                        passStack = new ItemStack(this.inventory.getStackInSlot(0).func_77973_b(), 1, this.inventory.getStackInSlot(0).func_77960_j());
                        if (this.inventory.getStackInSlot(0).func_77942_o()) {
                            passStack.func_77982_d(this.inventory.getStackInSlot(0).func_77978_p());
                        }
                        slot = -1;
                        for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
                            if (handler.getStackInSlot(j).func_190926_b()) {
                                slot = j;
                                continue;
                            }
                            if (handler.getStackInSlot(j).func_190916_E() >= handler.getSlotLimit(j) || !ItemStack.func_179545_c((ItemStack)handler.getStackInSlot(j), (ItemStack)this.inventory.getStackInSlot(0)) || !ItemStack.func_77970_a((ItemStack)handler.getStackInSlot(j), (ItemStack)this.inventory.getStackInSlot(0))) continue;
                            slot = j;
                        }
                        if (slot == -1 || !(added = handler.insertItem(slot, passStack, false)).func_190926_b() || (extracted = this.inventory.extractItem(0, 1, false)).func_190926_b()) continue;
                        if (tile2 instanceof TileEntityItemPipe) {
                            ((TileEntityItemPipe)tile2).lastReceived = this.func_174877_v();
                        }
                        if (!toUpdate.contains(this.func_174877_v().func_177972_a(face))) {
                            toUpdate.add(this.func_174877_v().func_177972_a(face));
                        }
                        if (toUpdate.contains(this.func_174877_v())) continue;
                        toUpdate.add(this.func_174877_v());
                    }
                }
                for (i = 0; i < toUpdate.size(); ++i) {
                    tile = this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i));
                    tile.func_70296_d();
                    if (this.func_145831_w().field_72995_K || tile instanceof ITileEntityBase) continue;
                    tile.func_70296_d();
                    EventManager.markTEForUpdate((BlockPos)toUpdate.get(i), tile);
                }
            }
        }
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public void setPressure(int pressure) {
        this.pressure = pressure;
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    public static enum EnumPipeConnection {
        NONE,
        PIPE,
        BLOCK,
        LEVER,
        FORCENONE,
        NEIGHBORNONE;

    }
}

