/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import teamroots.embers.RegistryManager;
import teamroots.embers.itemmod.ModifierBase;
import teamroots.embers.util.EmberInventoryUtil;
import teamroots.embers.util.ItemModUtil;
import teamroots.embers.util.Misc;

public class ModifierBlastingCore
extends ModifierBase {
    public ModifierBlastingCore() {
        super(ModifierBase.EnumType.ALL, "blasting_core", 2.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.BreakEvent event) {
        ItemStack s;
        if (event.getPlayer() != null && !event.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && ItemModUtil.getModifierLevel(s = event.getPlayer().func_184586_b(EnumHand.MAIN_HAND), ItemModUtil.modifierRegistry.get((Object)RegistryManager.blasting_core).name) > 0 && EmberInventoryUtil.getEmberTotal(event.getPlayer()) >= this.cost) {
            int blastingLevel = ItemModUtil.getModifierLevel(s, ItemModUtil.modifierRegistry.get((Object)RegistryManager.blasting_core).name);
            event.getWorld().func_72876_a((Entity)event.getPlayer(), (double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.5, (double)event.getPos().func_177952_p() + 0.5, 0.5f, true);
            for (int i = 0; i < 6; ++i) {
                EnumFacing face = EnumFacing.func_82600_a((int)i);
                if (Misc.random.nextInt(blastingLevel) == 0) continue;
                BlockPos pos = event.getPos().func_177972_a(face);
                if (!event.getPlayer().func_184823_b(event.getWorld().func_180495_p(pos))) continue;
                IBlockState state = event.getWorld().func_180495_p(pos);
                event.getWorld().func_175655_b(pos, true);
                event.getWorld().func_184138_a(pos, state, Blocks.field_150350_a.func_176223_P(), 8);
            }
            EmberInventoryUtil.removeEmber(event.getPlayer(), this.cost);
        }
    }

    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        EntityPlayer damager;
        ItemStack s;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !(s = (damager = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()).func_190926_b()) {
            int blastingLevel = ItemModUtil.getModifierLevel(s, ItemModUtil.modifierRegistry.get((Object)RegistryManager.blasting_core).name);
            float strength = (float)(2.0 * (Math.atan(0.6 * (double)blastingLevel) / Math.PI));
            if (blastingLevel > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
                event.getEntityLiving().field_70170_p.func_72876_a((Entity)event.getEntityLiving(), event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + (double)event.getEntityLiving().field_70131_O / 2.0, event.getEntityLiving().field_70161_v, 0.5f, true);
                EmberInventoryUtil.removeEmber(damager, this.cost);
                List entities = damager.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(event.getEntityLiving().field_70165_t - 4.0 * (double)strength, event.getEntityLiving().field_70163_u - 4.0 * (double)strength, event.getEntityLiving().field_70161_v - 4.0 * (double)strength, event.getEntityLiving().field_70165_t + 4.0 * (double)strength, event.getEntityLiving().field_70163_u + 4.0 * (double)strength, event.getEntityLiving().field_70161_v + 4.0 * (double)strength));
                for (EntityLivingBase e : entities) {
                    if (e.func_110124_au().compareTo(damager.func_110124_au()) == 0) continue;
                    e.func_70097_a(DamageSource.field_76377_j, event.getAmount() * strength);
                }
            }
        }
        if (event.getEntity() instanceof EntityPlayer) {
            int blastingLevel = ItemModUtil.getArmorMod((EntityPlayer)event.getEntity(), ItemModUtil.modifierRegistry.get((Object)RegistryManager.blasting_core).name);
            float strength = (float)(2.0 * (Math.atan(0.6 * (double)blastingLevel) / Math.PI));
            if (blastingLevel > 0 && EmberInventoryUtil.getEmberTotal((EntityPlayer)event.getEntity()) >= this.cost) {
                event.getEntityLiving().field_70170_p.func_72876_a((Entity)event.getEntityLiving(), event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + (double)event.getEntityLiving().field_70131_O / 2.0, event.getEntityLiving().field_70161_v, 0.5f, true);
                EmberInventoryUtil.removeEmber((EntityPlayer)event.getEntity(), this.cost);
                List entities = event.getEntity().field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(event.getEntityLiving().field_70165_t - 4.0 * (double)strength, event.getEntityLiving().field_70163_u - 4.0 * (double)strength, event.getEntityLiving().field_70161_v - 4.0 * (double)strength, event.getEntityLiving().field_70165_t + 4.0 * (double)strength, event.getEntityLiving().field_70163_u + 4.0 * (double)strength, event.getEntityLiving().field_70161_v + 4.0 * (double)strength));
                for (EntityLivingBase e : entities) {
                    if (e.func_110124_au().compareTo(event.getEntity().func_110124_au()) == 0) continue;
                    e.func_70097_a(DamageSource.field_76377_j, event.getAmount() * strength * 0.25f);
                    e.func_70653_a(event.getEntity(), 2.0f * strength, -e.field_70165_t + event.getEntity().field_70165_t, -e.field_70161_v + event.getEntity().field_70161_v);
                }
            }
        }
    }
}

