/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.creeperhost.minetogether.Util;
import net.creeperhost.minetogether.api.Order;
import net.creeperhost.minetogether.api.OrderSummary;
import net.creeperhost.minetogether.gui.GuiGetServer;
import net.creeperhost.minetogether.gui.element.GuiWell;
import net.creeperhost.minetogether.gui.list.GuiList;
import net.creeperhost.minetogether.gui.list.GuiListEntryCountry;
import net.creeperhost.minetogether.paul.Callbacks;
import net.minecraft.client.gui.GuiButton;

public class GuiQuote
extends GuiGetServer {
    private GuiList list;
    private boolean countryEnabled = false;
    private GuiWell wellLeft;
    private GuiWell wellRight;
    private GuiWell wellBottom;
    private GuiButton countryButton;
    private boolean refreshing;
    private boolean changed;
    private boolean firstTime = true;
    private boolean countryOnRelease;
    public OrderSummary summary;

    public GuiQuote(int stepId, Order order) {
        super(stepId, order);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.list = new GuiList(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 56, this.field_146295_m - 36, 36);
        this.wellLeft = new GuiWell(this.field_146297_k, this.field_146294_l / 2 - 10, 67, this.field_146295_m - 88, Util.localize("quote.vpsfeatures", new Object[0]), new ArrayList<String>(), true, 0);
        this.wellRight = new GuiWell(this.field_146297_k, this.field_146294_l, 67, this.field_146295_m - 88, Util.localize("quote.vpsincluded", new Object[0]), new ArrayList<String>(), true, this.field_146294_l / 2 + 10);
        this.wellBottom = new GuiWell(this.field_146297_k, this.field_146294_l, this.field_146295_m - 83, this.field_146295_m - 36, "", new ArrayList<String>(), true, 0);
        int start = this.field_146294_l / 2 + 10;
        int end = this.field_146294_l;
        int middle = (end - start) / 2;
        String name = Callbacks.getCountries().get(this.order.country);
        this.countryButton = new GuiButton(8008135, start + middle - 100, this.field_146295_m - 70, 200, 20, name);
        this.field_146292_n.add(this.countryButton);
        if (this.summary == null) {
            if (!this.refreshing) {
                this.updateSummary();
            }
            this.countryButton.field_146125_m = false;
        } else {
            this.wellLeft.lines = this.summary.serverFeatures;
            this.wellRight.lines = this.summary.serverIncluded;
            Map<String, String> locations = Callbacks.getCountries();
            for (Map.Entry<String, String> entry : locations.entrySet()) {
                GuiListEntryCountry listEntry = new GuiListEntryCountry(this.list, entry.getKey(), entry.getValue());
                this.list.addEntry(listEntry);
                if (!this.order.country.equals(listEntry.countryID)) continue;
                this.list.setCurrSelected(listEntry);
            }
        }
    }

    private void updateSummary() {
        this.countryButton.field_146125_m = false;
        this.refreshing = true;
        this.summary = null;
        final Order order = this.order;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GuiQuote.this.summary = Callbacks.getSummary(order);
                order.productID = GuiQuote.this.summary.productID;
                order.currency = GuiQuote.this.summary.currency;
                if (GuiQuote.this.firstTime) {
                    GuiQuote.this.firstTime = false;
                    Map<String, String> locations = Callbacks.getCountries();
                    for (Map.Entry<String, String> entry : locations.entrySet()) {
                        GuiListEntryCountry listEntry = new GuiListEntryCountry(GuiQuote.this.list, entry.getKey(), entry.getValue());
                        GuiQuote.this.list.addEntry(listEntry);
                        if (!order.country.equals(listEntry.countryID)) continue;
                        GuiQuote.this.list.setCurrSelected(listEntry);
                    }
                }
                ((GuiQuote)GuiQuote.this).wellLeft.lines = GuiQuote.this.summary.serverFeatures;
                ((GuiQuote)GuiQuote.this).wellRight.lines = GuiQuote.this.summary.serverIncluded;
                ((GuiQuote)GuiQuote.this).countryButton.field_146126_j = Callbacks.getCountries().get(order.country);
                ((GuiQuote)GuiQuote.this).countryButton.field_146125_m = true;
                GuiQuote.this.refreshing = false;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @Override
    public String getStepName() {
        return Util.localize("gui.quote", new Object[0]);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.buttonNext.field_146124_l = this.list.getCurrSelected() != null && !this.countryEnabled && !this.refreshing;
        this.buttonPrev.field_146124_l = !this.refreshing;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.countryEnabled) {
            this.list.func_178039_p();
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 8008135) {
            this.countryOnRelease = true;
        }
        if (this.countryEnabled && button.field_146127_k == this.buttonPrev.field_146127_k) {
            this.countryEnabled = false;
            this.buttonPrev.field_146126_j = Util.localize("button.prev", new Object[0]);
            if (this.changed) {
                this.changed = false;
                this.updateSummary();
            } else {
                this.countryButton.field_146125_m = true;
            }
            return;
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.countryEnabled) {
            this.list.func_148128_a(mouseX, mouseY, partialTicks);
        } else if (!this.refreshing) {
            if (!this.summary.summaryError.isEmpty()) {
                super.func_73863_a(mouseX, mouseY, partialTicks);
                this.func_73732_a(this.field_146289_q, Util.localize("quote.error", new Object[0]), this.field_146294_l / 2, 50, -1);
                this.func_73732_a(this.field_146289_q, Util.localize(this.summary.summaryError, new Object[0]), this.field_146294_l / 2, 60, -1);
                this.countryButton.field_146125_m = false;
                this.buttonNext.field_146125_m = false;
                this.buttonPrev.field_146125_m = false;
                return;
            }
            this.wellBottom.drawScreen();
            this.wellLeft.drawScreen();
            this.wellRight.drawScreen();
            this.func_73732_a(this.field_146289_q, Util.localize("quote.requirements", new Object[0]) + this.summary.serverHostName, this.field_146294_l / 2, 50, -1);
            String formatString = this.summary.prefix + "%1$.2f " + this.summary.suffix;
            String subTotalString = Util.localize("quote.subtotal", new Object[0]) + ":  ";
            int subTotalWidth = this.field_146289_q.func_78256_a(subTotalString);
            String discountString = Util.localize("quote.discount", new Object[0]) + ":  ";
            int discountWidth = this.field_146289_q.func_78256_a(discountString);
            String taxString = Util.localize("quote.tax", new Object[0]) + ":  ";
            int taxWidth = this.field_146289_q.func_78256_a(taxString);
            String totalString = Util.localize("quote.total", new Object[0]) + ":  ";
            int totalWidth = this.field_146289_q.func_78256_a(totalString);
            int headerSize = Math.max(subTotalWidth, Math.max(taxWidth, Math.max(totalWidth, discountWidth)));
            int subTotalValueWidth = this.field_146289_q.func_78256_a(String.format(formatString, this.summary.subTotal));
            int discountValueWidth = this.field_146289_q.func_78256_a(String.format(formatString, this.summary.discount));
            int taxValueWidth = this.field_146289_q.func_78256_a(String.format(formatString, this.summary.tax));
            int totalValueWidth = this.field_146289_q.func_78256_a(String.format(formatString, this.summary.tax));
            int maxStringSize = headerSize + Math.max(subTotalValueWidth, Math.max(discountValueWidth, Math.max(taxValueWidth, totalValueWidth)));
            int offset = maxStringSize / 2;
            int otherOffset = (this.field_146294_l / 2 - 10) / 2 - offset;
            this.func_73731_b(this.field_146289_q, subTotalString, otherOffset, this.field_146295_m - 80, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, String.format(formatString, this.summary.preDiscount), otherOffset + headerSize, this.field_146295_m - 80, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, discountString, otherOffset, this.field_146295_m - 70, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, String.format(formatString, this.summary.discount), otherOffset + headerSize, this.field_146295_m - 70, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, taxString, otherOffset, this.field_146295_m - 60, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, String.format(formatString, this.summary.tax), otherOffset + headerSize, this.field_146295_m - 60, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, totalString, otherOffset, this.field_146295_m - 50, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, String.format(formatString, this.summary.total), otherOffset + headerSize, this.field_146295_m - 50, 0xFFFFFF);
            int start = this.field_146294_l / 2 + 10;
            int end = this.field_146294_l;
            int middle = (end - start) / 2;
            int stringStart = this.field_146289_q.func_78256_a(Util.localize("quote.figures", new Object[0])) / 2;
            this.func_73731_b(this.field_146289_q, Util.localize("quote.figures", new Object[0]), start + middle - stringStart, this.field_146295_m - 80, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, Util.localize("quote.refreshing", new Object[0]), this.field_146294_l / 2, 50, -1);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.countryEnabled && this.list.func_148179_a(mouseX, mouseY, mouseButton)) {
            GuiListEntryCountry country = (GuiListEntryCountry)this.list.getCurrSelected();
            this.order.country = country.countryID;
            this.changed = true;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.countryEnabled) {
            this.list.func_148181_b(mouseX, mouseY, state);
        }
        if (this.countryOnRelease) {
            this.countryOnRelease = false;
            this.countryEnabled = !this.countryEnabled;
            this.buttonPrev.field_146126_j = Util.localize("button.quoteback", new Object[0]);
            this.countryButton.field_146125_m = false;
            return;
        }
    }
}

