/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import java.io.IOException;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.Util;
import net.creeperhost.minetogether.api.Order;
import net.creeperhost.minetogether.gui.GuiGeneralServerInfo;
import net.creeperhost.minetogether.gui.GuiOrderDetails;
import net.creeperhost.minetogether.gui.GuiPersonalDetails;
import net.creeperhost.minetogether.gui.GuiQuote;
import net.creeperhost.minetogether.gui.GuiServerLocation;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;

public abstract class GuiGetServer
extends GuiScreen {
    private static final int STEP_AMOUNT = 5;
    protected final int stepId;
    protected GuiButton buttonPrev;
    protected GuiButton buttonNext;
    protected GuiButton buttonCancel;
    protected final Order order;

    public GuiGetServer(int stepId, Order order) {
        CreeperHost.instance.updateCurse();
        this.stepId = stepId;
        this.order = order;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int y = this.field_146295_m - 30;
        this.buttonPrev = new GuiButton(-1, 10, y, 80, 20, Util.localize("button.prev", new Object[0]));
        this.buttonPrev.field_146124_l = this.stepId > 0;
        this.field_146292_n.add(this.buttonPrev);
        String nextStr = "";
        nextStr = this.stepId + 1 == 5 ? Util.localize("button.done", new Object[0]) : (this.stepId == 3 ? Util.localize("button.order", new Object[0]) : Util.localize("button.next", new Object[0]));
        this.buttonNext = new GuiButton(-2, this.field_146294_l - 90, y, 80, 20, nextStr);
        this.field_146292_n.add(this.buttonNext);
        this.buttonCancel = new GuiButton(-3, this.field_146294_l / 2 - 40, y, 80, 20, Util.localize("button.cancel", new Object[0]));
        this.field_146292_n.add(this.buttonCancel);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73732_a(this.field_146289_q, Util.localize("gui.get_server", new Object[0]), this.field_146294_l / 2, 10, -1);
        this.func_73732_a(this.field_146289_q, Util.localize("info.step", this.stepId + 1, 5), this.field_146294_l / 2, 30, -1);
        this.func_73732_a(this.field_146289_q, this.getStepName(), this.field_146294_l / 2, 40, -1);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.buttonPrev) {
            this.field_146297_k.func_147108_a(GuiGetServer.getByStep(this.stepId - 1, this.order));
        } else if (button == this.buttonNext) {
            if (this.stepId + 1 == 5) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiMultiplayer(null));
            } else {
                this.field_146297_k.func_147108_a(GuiGetServer.getByStep(this.stepId + 1, this.order));
            }
        } else if (button == this.buttonCancel) {
            this.field_146297_k.func_147108_a(null);
        } else {
            super.func_146284_a(button);
        }
    }

    public static GuiScreen getByStep(int step, Order order) {
        switch (step) {
            default: {
                return new GuiGeneralServerInfo(0, order);
            }
            case 1: {
                return new GuiQuote(1, order);
            }
            case 2: {
                return new GuiServerLocation(2, order);
            }
            case 3: {
                return new GuiPersonalDetails(3, order);
            }
            case 4: 
        }
        return new GuiOrderDetails(4, order);
    }

    public abstract String getStepName();
}

