/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import shetiphian.core.common.Function;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class TileEntityEnderTank
extends TileEntityBase
implements IRGB16_Tile {
    private String code = "000";
    private String ownerID = null;
    private String owner = "all";
    private ItemStack personalItem;
    private final ArrayList<ItemStack> pumpUpgrades = new ArrayList();
    public boolean rayTracing = false;
    public int tracePart = 0;
    public long lastClick = 0L;

    public void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("code", this.getCode());
        nbtTag.func_74778_a("owner", this.owner);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            nbtTag.func_74778_a("ownerID", this.ownerID);
        }
        if (!this.pumpUpgrades.isEmpty()) {
            NBTTagList listItems = new NBTTagList();
            for (ItemStack stack : this.pumpUpgrades) {
                NBTTagCompound compound = new NBTTagCompound();
                stack.func_77955_b(compound);
                listItems.func_74742_a((NBTBase)compound);
            }
            nbtTag.func_74782_a("PumpUpgrades", (NBTBase)listItems);
        }
        if (this.personalItem != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.personalItem.func_77955_b(compound);
            nbtTag.func_74782_a("PersonalUpgrade", (NBTBase)compound);
        }
    }

    public void processNBT(NBTTagCompound nbtTag) {
        this.setCode(nbtTag.func_74779_i("code"));
        this.owner = nbtTag.func_74779_i("owner");
        if (nbtTag.func_74764_b("ownerID")) {
            this.ownerID = nbtTag.func_74779_i("ownerID");
        }
        if (nbtTag.func_74764_b("PumpUpgrades")) {
            this.pumpUpgrades.clear();
            NBTTagList listItems = nbtTag.func_150295_c("PumpUpgrades", 10);
            for (int entry = 0; entry < listItems.func_74745_c(); ++entry) {
                NBTTagCompound compound = listItems.func_150305_b(entry);
                ItemStack stack = new ItemStack(compound);
                if (stack.func_190926_b()) continue;
                if (stack.func_190916_E() != 1) {
                    stack.func_190920_e(1);
                }
                this.pumpUpgrades.add(stack);
            }
        } else if (nbtTag.func_74764_b("pump")) {
            for (byte x = 0; x < nbtTag.func_74771_c("pump"); x = (byte)(x + 1)) {
                this.pumpUpgrades.add(new ItemStack((Block)Blocks.field_150331_J));
            }
        }
        if (nbtTag.func_74764_b("PersonalUpgrade")) {
            ItemStack stack = new ItemStack(nbtTag.func_74775_l("PersonalUpgrade"));
            if (!stack.func_190926_b() && stack.func_190916_E() != 1) {
                stack.func_190920_e(1);
            }
            this.personalItem = stack;
        }
    }

    public void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        FluidTankInfo tankInfo = this.getTankInfo();
        if (tankInfo.fluid != null) {
            nbtTag.func_74778_a("liquid", tankInfo.fluid.getFluid().getLocalizedName(tankInfo.fluid));
            nbtTag.func_74768_a("amount", tankInfo.fluid.amount);
            nbtTag.func_74768_a("capacity", this.getTank().getCapacity());
        } else {
            nbtTag.func_74778_a("liquid", "NONE");
        }
    }

    public void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            this.owner = NameHelper.getDisplayNameFor((String)this.ownerID);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.canBeAutomated() && this.canInteractFromFace(facing) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.canBeAutomated() && this.canInteractFromFace(facing)) {
            return (T)this.getTank();
        }
        return (T)super.getCapability(capability, facing);
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? Configuration.ACCESS_SETTINGS.enableAutomationPublic : (this.isTeam() ? Configuration.ACCESS_SETTINGS.enableAutomationTeam : Configuration.ACCESS_SETTINGS.enableAutomationPersonal);
    }

    private boolean canInteractFromFace(EnumFacing facing) {
        EnumFacing tFacing = BlockEnderTank.getFacing(this.func_145831_w().func_180495_p(this.func_174877_v()));
        return facing == null || tFacing.func_176740_k() == facing.func_176740_k();
    }

    public FluidTank getTank() {
        return TankHelper.getTank(this.getOwnerID(), this.getCode(), this.func_145831_w().field_72995_K);
    }

    public FluidTankInfo getTankInfo() {
        return this.getTank().getInfo();
    }

    public int getPumpCapacity() {
        return this.pumpUpgrades.isEmpty() ? 250 : this.pumpUpgrades.size() * 1000;
    }

    public byte getPumpUpgradeCount() {
        return (byte)this.pumpUpgrades.size();
    }

    public void addPumpUpgrade(ItemStack stack) {
        this.pumpUpgrades.add(stack);
    }

    public boolean canEdit(EntityPlayer player) {
        boolean canEdit = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                canEdit = !Configuration.ACCESS_SETTINGS.lockTeamEdit || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = !Configuration.ACCESS_SETTINGS.lockPersonalEdit || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                msg = "private.denied";
            }
        }
        if (!canEdit && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canEdit;
    }

    public boolean canUse(EntityPlayer player) {
        boolean canUse = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                canUse = !Configuration.ACCESS_SETTINGS.lockTeamUse || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = Configuration.ACCESS_SETTINGS.allowPublicTanks;
                msg = "public.disabled";
            } else {
                canUse = !Configuration.ACCESS_SETTINGS.lockPersonalUse || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canUse;
    }

    public boolean canLink(EntityPlayer player) {
        boolean canLink = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                if (Configuration.ACCESS_SETTINGS.allowTeamBuckets) {
                    canLink = !Configuration.ACCESS_SETTINGS.lockTeamLink || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "tank.team.denied";
                } else {
                    canLink = false;
                    msg = "bucket.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (Configuration.ACCESS_SETTINGS.allowPersonalBuckets) {
                    canLink = !Configuration.ACCESS_SETTINGS.lockPersonalLink || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                    msg = "tank.private.denied";
                } else {
                    canLink = false;
                    msg = "bucket.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(EntityPlayer player) {
        String team = Function.getPlayerTeamID((EntityPlayer)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    private String getOwner() {
        return !Strings.isNullOrEmpty((String)this.owner) ? this.owner : "all";
    }

    public String getOwnerID() {
        if (this.getOwner().equalsIgnoreCase("all")) {
            return "all";
        }
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            return this.ownerID;
        }
        return this.getOwner();
    }

    public String getOwnerName() {
        return TankInfoHelper.getDisplayNameFromOwnerID(this.ownerID);
    }

    public void setOwner(EntityPlayer player, ItemStack stack) {
        this.personalItem = stack;
        this.owner = player.getDisplayNameString();
        this.ownerID = player.func_110124_au().toString();
    }

    public void setOwner(String ownerName, String ownerID, ItemStack stack) {
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
    }

    public ItemStack getPersonalItem() {
        if (this.personalItem != null) {
            if (this.personalItem.func_190916_E() != 1) {
                this.personalItem.func_190920_e(1);
            }
            return this.personalItem;
        }
        return null;
    }

    public ArrayList<ItemStack> getPumpUpgrades() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        if (!this.pumpUpgrades.isEmpty()) {
            for (ItemStack stack : this.pumpUpgrades) {
                if (stack == null) continue;
                if (stack.func_190916_E() != 1) {
                    stack.func_190920_e(1);
                }
                upgrades.add(stack);
            }
        }
        return upgrades;
    }

    public boolean isPublic() {
        return this.getOwner().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.ownerID != null && this.ownerID.startsWith("#");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        while (code.length() < 3) {
            code = "0" + code;
        }
        this.code = code.toUpperCase();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.ownerID);
    }

    public RGB16 getRGB16(EntityPlayer player) {
        int ring = this.getRingHit(player);
        if (ring < 0) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(EnumDyeColor.func_176764_b((int)value).func_176610_l());
    }

    public boolean setRGB16(short rgbIndex, EntityPlayer player) {
        return this.doColorRing(EnumDyeColor.func_176764_b((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(EnumDyeColor color, EntityPlayer player) {
        if (!this.canEdit(player) || !Configuration.enableInWorldRecoloring) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0) {
            return false;
        }
        char charColor = Integer.toHexString(color.func_176765_a()).charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((TileEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(EntityPlayer player) {
        Function.BlockInfo info = Function.getBlockInfront((World)this.func_145831_w(), (EntityPlayer)player, (double)5.0, (boolean)false);
        if (info == null || info.sub < 1 || info.sub > 3) {
            return -1;
        }
        return info.sub - 1;
    }
}

