/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemMulti;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.item.EnderFluidHandlerItemStack;
import shetiphian.endertanks.common.misc.CauldronHelper;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class ItemEnderBucket
extends ItemMulti
implements IColored {
    public ItemEnderBucket() {
        super("ItemEnderBucket", Values.nameMapper);
        this.field_77777_bU = 1;
        this.field_77787_bX = true;
        this.func_77637_a((CreativeTabs)Values.tabEnderTanks);
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        for (String code : StackHelper.BASE_CODES) {
            list.add((Object)StackHelper.create((Item)this, code, null));
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77952_i() == 0 && !Configuration.ACCESS_SETTINGS.allowPublicBuckets) {
            if (!Configuration.ACCESS_SETTINGS.allowPersonalBuckets) {
                String teamID = Function.getPlayerTeamID((EntityPlayer)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    stack.func_77964_b(3);
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                stack.func_77964_b(1);
                StackHelper.setOwner(stack, player.func_110124_au().toString());
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        EnumFacing facing;
        ItemStack stack = player.func_184586_b(hand);
        boolean isSneaking = player.func_70093_af();
        RayTraceResult mop = this.func_77621_a(world, player, !isSneaking);
        BlockPos pos = mop != null ? mop.func_178782_a() : null;
        Boolean hitTypeBlock = mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK;
        EnumFacing enumFacing = facing = mop != null ? mop.field_178784_b : EnumFacing.func_176741_a((Random)world.field_73012_v);
        if (!world.field_72995_K) {
            if (isSneaking && pos != null) {
                if (world.func_180495_p(pos).func_177230_c() == Values.blockEnderTank) {
                    TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_175625_s(pos);
                    if (tankTile != null) {
                        if (tankTile.hasError()) {
                            TankInfoHelper.sendLinkError(player, 2);
                        } else {
                            if (tankTile.canLink(player)) {
                                return new ActionResult(EnumActionResult.SUCCESS, (Object)StackHelper.create((Item)this, tankTile.getCode(), tankTile.getOwnerID()));
                            }
                            TankInfoHelper.sendLinkError(player, tankTile.isTeam() ? 3 : 1);
                        }
                    }
                } else if (stack.func_77952_i() != 0 || Configuration.ACCESS_SETTINGS.allowPublicBuckets) {
                    this.placeLiquid(stack, player, world, pos, facing, hitTypeBlock);
                } else {
                    TankInfoHelper.sendError(player, "endertanks.bucket.public.disabled");
                }
            } else if (stack.func_77952_i() != 0 || Configuration.ACCESS_SETTINGS.allowPublicBuckets) {
                if (pos == null || !this.pickupLiquid(stack, player, world, pos, facing)) {
                    String[] network = new String[]{StackHelper.getOwnerID(stack), StackHelper.getCode(stack)};
                    FluidTank bucketTank = TankHelper.getTank(network[0], network[1], false);
                    FluidStack bucketLiquid = bucketTank.getFluid();
                    TankInfoHelper.sendTankInfo(player, bucketLiquid, StackHelper.getOwnerName(stack), network[0], network[1]);
                }
            } else {
                TankInfoHelper.sendError(player, "endertanks.bucket.public.disabled");
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private boolean pickupLiquid(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing) {
        if (player.func_175151_a(pos, facing, stack)) {
            FluidTank bucketTank = TankHelper.getTank(StackHelper.getOwnerID(stack), StackHelper.getCode(stack), world.field_72995_K);
            IFluidHandler fromHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)facing);
            if (fromHandler != null) {
                FluidStack bucketLiquid = bucketTank.getFluid();
                int getAmount = bucketLiquid != null ? Math.min(1000, bucketTank.getCapacity() - bucketLiquid.amount) : 1000;
                FluidStack getLiquid = FluidUtil.tryFluidTransfer((IFluidHandler)bucketTank, (IFluidHandler)fromHandler, (int)getAmount, (boolean)true);
                if (getLiquid != null) {
                    world.func_184133_a(null, pos, getLiquid.getFluid().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (player.field_71075_bZ.field_75098_d) {
                        bucketTank.drain(getLiquid, true);
                    }
                }
            } else if (CauldronHelper.isCauldron((IBlockAccess)world, pos) && CauldronHelper.drainCauldron((IFluidHandler)bucketTank, world, pos, !player.field_71075_bZ.field_75098_d)) {
                world.func_184133_a(null, pos, FluidRegistry.WATER.getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        return false;
    }

    private void placeLiquid(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, boolean hitTypeBlock) {
        FluidStack placeLiquid;
        BlockPos sPos;
        FluidTank bucketTank = TankHelper.getTank(StackHelper.getOwnerID(stack), StackHelper.getCode(stack), world.field_72995_K);
        FluidStack bucketLiquid = bucketTank.getFluid();
        int putAmount = bucketLiquid != null ? Math.min(1000, bucketLiquid.amount) : 0;
        IFluidHandler toHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)facing);
        if (toHandler != null) {
            FluidStack putLiquid;
            if (player.func_175151_a(pos, facing, stack) && (putLiquid = FluidUtil.tryFluidTransfer((IFluidHandler)toHandler, (IFluidHandler)bucketTank, (int)putAmount, (boolean)true)) != null) {
                world.func_184133_a(null, pos, putLiquid.getFluid().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (player.field_71075_bZ.field_75098_d) {
                    bucketTank.fill(putLiquid, true);
                }
            }
        } else if (CauldronHelper.isCauldron((IBlockAccess)world, pos)) {
            if (player.func_175151_a(pos, facing, stack) && CauldronHelper.fillCauldron((IFluidHandler)bucketTank, world, pos, !player.field_71075_bZ.field_75098_d)) {
                world.func_184133_a(null, pos, FluidRegistry.WATER.getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        } else if (putAmount >= 1000 && hitTypeBlock && player.func_175151_a(sPos = pos.func_177972_a(facing), facing, stack) && FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)sPos, (ItemStack)stack, (FluidStack)(placeLiquid = bucketTank.drain(1000, false))).isSuccess()) {
            world.func_190524_a(sPos, Blocks.field_150350_a, sPos);
            if (player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
                bucketTank.fill(placeLiquid, true);
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return stack.func_190926_b() ? null : new EnderFluidHandlerItemStack(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        tooltip.add(" " + Localization.get((String)"info.endertanks.tank.code.txt") + " " + StackHelper.getCode(stack));
        String owner = TankInfoHelper.formatTankOwner(StackHelper.getOwnerName(stack));
        if (!Strings.isNullOrEmpty((String)owner)) {
            tooltip.add(owner);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.func_190926_b()) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    protected void addToNameMap() {
        this.add(0, "", "enderbucket_public", "public");
        this.add(1, "", "enderbucket_private", "private");
        this.add(2, "", "enderbucket_team", "team");
    }
}

