/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;

public class EnderFluidHandlerItemStack
extends FluidHandlerItemStack {
    public EnderFluidHandlerItemStack(ItemStack stack) {
        super(stack, 0);
    }

    private FluidTank getTank() {
        return TankHelper.getTank(StackHelper.getOwnerID(this.container), StackHelper.getCode(this.container), FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT);
    }

    public FluidStack getFluid() {
        return this.getTank().getFluid();
    }

    protected void setFluid(FluidStack fluid) {
        this.getTank().setFluid(fluid);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.getTank().getCapacity())};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained == null) {
            int fillAmount = Math.min(this.getTank().getCapacity(), resource.amount);
            if (doFill) {
                FluidStack filled = resource.copy();
                filled.amount = fillAmount;
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getTank().getCapacity() - contained.amount, resource.amount);
            if (doFill && fillAmount > 0) {
                contained.amount += fillAmount;
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    protected void setContainerToEmpty() {
        this.getTank().setFluid(null);
    }
}

