/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.parser;

import cofh.cofhworld.decoration.IGeneratorParser;
import cofh.cofhworld.feature.parser.SurfaceParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.WorldGenDecoration;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class DecorationParser
extends SurfaceParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
        int clusterSize = genObject.getInt("cluster-size");
        if (clusterSize <= 0) {
            log.warn("Invalid cluster size for generator '{}'", (Object)name);
            return null;
        }
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        ConfigObject genData = genObject.root();
        if (!genObject.hasPath("surface")) {
            log.info("Entry does not specify surface for 'decoration' generator. Using grass.");
            list.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
        } else if (!FeatureParser.parseResList(genData.get("surface"), list, false)) {
            log.warn("Entry specifies invalid surface for 'decoration' generator! Using grass!");
            list.clear();
            list.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
        }
        WorldGenDecoration r = new WorldGenDecoration(resList, clusterSize, matList, list);
        if (genObject.hasPath("see-sky")) {
            r.setSeeSky(genObject.getBoolean("see-sky"));
        }
        if (genObject.hasPath("check-stay")) {
            r.setCheckStay(genObject.getBoolean("check-stay"));
        }
        if (genObject.hasPath("stack-height")) {
            r.setStackHeight(FeatureParser.parseNumberValue(genData.get("stack-height")));
        }
        if (genObject.hasPath("x-variance")) {
            r.setXVar(FeatureParser.parseNumberValue(genData.get("x-variance"), 0, 15));
        }
        if (genObject.hasPath("y-variance")) {
            r.setYVar(FeatureParser.parseNumberValue(genData.get("y-variance")));
        }
        if (genObject.hasPath("z-variance")) {
            r.setZVar(FeatureParser.parseNumberValue(genData.get("z-variance"), 0, 15));
        }
        return r;
    }

    @Override
    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Collections.singletonList(new WeightedRandomBlock((Block)Blocks.field_150349_c, -1));
    }

    @Override
    protected String getDefaultGenerator() {
        return "decoration";
    }
}

