/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.IAbilityTypeRegistry;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;

public class AbilityTypeRegistry
implements IAbilityTypeRegistry {
    private static final AbilityTypeRegistry INSTANCE = new AbilityTypeRegistry();
    private final Map<String, IAbilityType> abilities = Maps.newHashMap();
    private final Map<EnumRarity, List<IAbilityType>> rarityAbilities = Maps.newIdentityHashMap();

    private AbilityTypeRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static AbilityTypeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <A extends IAbilityType> A register(A abilityType) {
        this.abilities.put(abilityType.getUnlocalizedName(), abilityType);
        this.rarityAbilities.computeIfAbsent(abilityType.getRarity(), rarity -> Lists.newArrayList()).add(abilityType);
        return abilityType;
    }

    @Override
    public IAbilityType getAbilityType(String unlocalizedName) {
        return this.abilities.get(unlocalizedName);
    }

    @Override
    public Collection<IAbilityType> getAbilityTypes() {
        return Collections.unmodifiableCollection(this.abilities.values());
    }

    @Override
    public List<IAbilityType> getAbilityTypes(EnumRarity rarity) {
        return this.rarityAbilities.getOrDefault(rarity, Collections.emptyList());
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IAbilityStore abilityStore = (IAbilityStore)player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
            for (Ability ability : abilityStore.getAbilities()) {
                if (event.getEntity().field_70170_p.func_82737_E() % 20L == 0L && GeneralConfig.exhaustionPerAbilityTick > 0.0) {
                    player.func_71020_j((float)GeneralConfig.exhaustionPerAbilityTick);
                }
                ability.getAbilityType().onTick(player, ability.getLevel());
            }
        }
    }
}

