/*
 * Decompiled with CFR 0.152.
 */
package mcjty.nice.particle.systems;

import java.util.Random;
import mcjty.nice.particle.DefaultCalculatedParticleSystem;
import mcjty.nice.particle.DefaultParticle;
import net.minecraft.util.math.Vec3d;

public class FishCalculatedSystem
extends DefaultCalculatedParticleSystem {
    private static Random random = new Random();
    private Vec3d[] position;
    private Vec3d[] movement;

    public FishCalculatedSystem() {
        super(random.nextInt(3) + 1);
        int amount = this.particles.size();
        this.position = new Vec3d[amount];
        this.movement = new Vec3d[amount];
        for (int i = 0; i < amount; ++i) {
            this.position[i] = new Vec3d(random.nextDouble() * 0.8 - 0.4, random.nextDouble() * 0.8 - 0.4, random.nextDouble() * 0.8 - 0.4);
            this.randomMovement(i);
            DefaultParticle particle = (DefaultParticle)this.particles.get(i);
            int type = random.nextInt(3);
            particle.setUV(((double)type + 1.0) / 8.0, 0.0, ((double)type + 2.0) / 8.0, 0.125);
            particle.setColor(255, 255, 255, 255);
            particle.setScale(0.2);
            particle.setOffset(this.position[i]);
        }
    }

    private void randomMovement(int i) {
        this.movement[i] = new Vec3d(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5).func_72432_b().func_186678_a(0.01);
    }

    public void update(long time) {
        for (int i = 0; i < this.position.length; ++i) {
            Vec3d o = this.position[i];
            DefaultParticle particle = (DefaultParticle)this.particles.get(i);
            float offset = (float)(time % 2000L) / 2000.0f;
            Vec3d newo = o.func_178787_e(this.movement[i].func_186678_a((double)offset));
            if (newo.field_72450_a <= -0.4 || newo.field_72448_b <= -0.4 || newo.field_72449_c <= -0.4 || newo.field_72450_a >= 0.4 || newo.field_72448_b >= 0.4 || newo.field_72449_c >= 0.4) {
                this.randomMovement(i);
                continue;
            }
            this.position[i] = newo;
            particle.setOffset(newo);
        }
    }
}

