/*
 * Decompiled with CFR 0.152.
 */
package mcjty.nice.particle;

import mcjty.lib.client.RenderHelper;
import mcjty.nice.particle.ICalculatedParticleSystem;
import mcjty.nice.particle.IParticle;
import mcjty.nice.particle.IParticleProvider;
import mcjty.nice.particle.IParticleSystem;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class ParticleRenderer {
    public static ResourceLocation particles = new ResourceLocation("nice", "textures/effects/particles.png");

    public static void renderParticleSystem(IParticleProvider provider, BufferBuilder buffer) {
        long time = System.currentTimeMillis();
        int brightness = 240;
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        IParticleSystem system = provider.getParticleSystem();
        ICalculatedParticleSystem calculated = provider.getCalculatedParticleSystem();
        system.update(calculated, time);
        for (IParticle particle : calculated.getParticles()) {
            double ox = particle.getOffset().field_72450_a;
            double oy = particle.getOffset().field_72448_b;
            double oz = particle.getOffset().field_72449_c;
            double u1 = particle.getU1();
            double u2 = particle.getU2();
            double v1 = particle.getV1();
            double v2 = particle.getV2();
            int r = particle.getR();
            int g = particle.getG();
            int b = particle.getB();
            int a = particle.getA();
            double scale = particle.getScale();
            buffer.func_181662_b(ox - scale, oy - scale, oz).func_187315_a(u1, v1).func_187314_a(b1, b2).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(ox - scale, oy + scale, oz).func_187315_a(u1, v2).func_187314_a(b1, b2).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(ox + scale, oy + scale, oz).func_187315_a(u2, v2).func_187314_a(b1, b2).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b(ox + scale, oy - scale, oz).func_187315_a(u2, v1).func_187314_a(b1, b2).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    public static void renderSystem(IParticleProvider provider, float x, float y, float z) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179118_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.5f), (float)(z + 0.5f));
        RenderHelper.rotateToPlayer();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        ParticleRenderer.renderParticleSystem(provider, buffer);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
    }
}

