# Lua 

Книги [Lua руководство](http://www.lua.org/manual/5.2/manual.html) и [Программирование на Lua](http://www.lua.org/pil/) (первое издание доступно бесплатно) хорошее начало, для получения базовых навыков программирования на Lua, ознакомления с синтаксисом и стандартными библиотеками. [OpenOS](openOS.md) стремится соответствовать стандартным библиотекам, с несколькими различиями, например отладочная библиотека. Эти различия [документированы в wiki](http://ocdoc.cil.li/api:non-standard-lua-libs).

Нестандартные библиотеки должны быть `подключены`, для использования их в скриптах. Например:

`local component = require("component")`
`local rs = component.redstone`

Это позвонил вызывать и использовать функции [редстоун карты](../item/redstoneCard1.md). Например:

`rs.setOutput(require("sides").front, 15)`

**Важно**: при работе с интерпретатором Lua, *не* используйте несколько `local` в одной строке. Если вы вставите третью строку выше подключения библиотеки, вы получите ошибку, так как вызов `rs` будет иметь значение `nil`. Почему только на третьей строке, спросите вы? Потому, что для простоты тестирования, интерпретатор пытается загрузить неизвестные переменные, как библиотеки. Хотя на после первой строки ничего не произойдет, то на второй строке вызов `component` вызовет эту библиотеку и запустит ее. Библиотеки не подгружаются автоматически, их нужно вызвать, это сделано для экономии ресурсов.

OpenOS предоставляет множество дополнительных библиотек и программ, начиная от контроля и управления компонентами [компьютера](computer.md) и заканчивая API для многожильного редстоун-кабеля, а также кодов клавиш [клавиатуры](../block/keyboard.md). Дополнительные библиотеки могут быть подключены к Lua скрипту через функцию `require()`, как показано выше. Некоторые библиотеки требуют определенные компоненты для работы, например `интернет` библиотека требует [интернет карту](../item/internetCard.md). В данном случае, библиотека станет доступна, только после установки интернет карты.
