/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.upgrade.upgradeList;

import chbachman.api.configurability.Configurable;
import chbachman.api.configurability.ConfigurableField;
import chbachman.api.configurability.Percentage;
import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTInteger;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Upgrade;
import chbachman.api.util.ArmourSlot;
import chbachman.armour.util.ConfigHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;

public class UpgradeAutoFeeder
extends Upgrade {
    private NBTInteger storedFood = new NBTInteger("foodLevel", 0);
    @Configurable
    public ConfigurableField foodAmount = new ConfigurableField(this, "foodAmount", 100);
    private int absorbing;
    private int eating;
    private int amountToHold;

    public UpgradeAutoFeeder() {
        super("feeder");
    }

    @Override
    public void registerConfigOptions() {
        this.absorbing = ConfigHelper.get("energy values", (IUpgrade)this, "cost for absorbing food", 100);
        this.eating = ConfigHelper.get("energy values", (IUpgrade)this, "cost for eating food", 100);
        this.amountToHold = ConfigHelper.get("other values", (IUpgrade)this, "amount of food to hold", 20);
    }

    @Override
    public boolean isCompatible(IModularItem item, ItemStack stack, int armourType) {
        return armourType == ArmourSlot.HELMET.id;
    }

    @Override
    public int onTick(World world, EntityPlayer player, ItemStack stack, ArmourSlot slot) {
        FoodStats food;
        int modifiedAmount = this.amountToHold * ((Percentage)this.foodAmount.get(stack)).getAmount();
        if (this.storedFood.get(stack) < modifiedAmount) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack playerStack = player.field_71071_by.field_70462_a[i];
                if (playerStack == null || !(playerStack.func_77973_b() instanceof ItemFood)) continue;
                ItemFood food2 = (ItemFood)playerStack.func_77973_b();
                int amountToStore = food2.func_150905_g(playerStack);
                if (modifiedAmount - this.storedFood.get(stack) < amountToStore) continue;
                this.storedFood.set(stack, this.storedFood.get(stack) + amountToStore);
                --playerStack.field_77994_a;
                if (playerStack.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[i] = null;
                }
                return this.absorbing;
            }
        }
        if ((food = player.func_71024_bL()).func_75121_c() && this.storedFood.get(stack) > 0) {
            int foodNeeded = 20 - food.func_75116_a();
            food.func_75122_a(foodNeeded, 0.0f);
            this.storedFood.set(stack, this.storedFood.get(stack) - foodNeeded);
            return this.eating;
        }
        return 0;
    }
}

