/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.upgrade;

import chbachman.api.configurability.Configurable;
import chbachman.api.configurability.ConfigurableField;
import chbachman.api.configurability.Percentage;
import chbachman.api.item.IModularItem;
import chbachman.api.util.ArmourSlot;
import chbachman.armour.upgrade.upgradeList.UpgradeBasic;
import chbachman.armour.util.EnergyUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public abstract class UpgradeProtective
extends UpgradeBasic {
    @Configurable
    public ConfigurableField protection = new ConfigurableField(this.getBaseName() + "Protection", "upgrade.chbachman.protection.protection", 50);
    final int maxProtection;

    public UpgradeProtective(String name, int protection) {
        super(name);
        this.maxProtection = protection;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
        IModularItem item = (IModularItem)armor.func_77973_b();
        if (EnergyUtil.isEmpty(armor)) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        if (this.shouldDefend(player, armor, source, damage, slot)) {
            item.damageArmour(armor, (int)((double)this.getEnergyPerDamage(armor) * damage));
            float temp = (float)this.maxProtection * ((Percentage)this.protection.get(armor)).getPercentage() * ((float)this.limitDamage(player, armor, source, damage, slot) / 100.0f);
            return new ISpecialArmor.ArmorProperties(0, (double)(temp / 100.0f), Integer.MAX_VALUE);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    @Override
    public boolean isCompatible(IModularItem item, ItemStack stack, int armorType) {
        return item.isArmour();
    }

    @Override
    public int getArmourDisplay(EntityPlayer player, ItemStack stack, ArmourSlot slot) {
        return ((Percentage)this.protection.get(stack)).getAmount() / 25;
    }

    public int limitDamage(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
        switch (slot) {
            case HELMET: {
                return 15;
            }
            case CHESTPLATE: {
                return 40;
            }
            case LEGS: {
                return 30;
            }
            case BOOTS: {
                return 15;
            }
        }
        return 0;
    }

    public abstract boolean shouldDefend(EntityLivingBase var1, ItemStack var2, DamageSource var3, double var4, ArmourSlot var6);

    public abstract int getEnergyPerDamage(ItemStack var1);

    public static class UpgradeGeneralProtection
    extends UpgradeProtective {
        public UpgradeGeneralProtection() {
            super("generalProtection", 80);
        }

        @Override
        public boolean shouldDefend(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
            return true;
        }

        @Override
        public int getEnergyPerDamage(ItemStack stack) {
            return 100;
        }
    }

    public static class UpgradeLava
    extends UpgradeProtective {
        public UpgradeLava() {
            super("lavaProtector", 75);
        }

        @Override
        public boolean shouldDefend(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
            return source == DamageSource.field_76371_c;
        }

        @Override
        public int getEnergyPerDamage(ItemStack stack) {
            return 100;
        }
    }

    public static class UpgradeWither
    extends UpgradeProtective {
        public UpgradeWither() {
            super("witherProtector", 20);
        }

        @Override
        public boolean shouldDefend(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
            return source == DamageSource.field_82727_n;
        }

        @Override
        public int getEnergyPerDamage(ItemStack stack) {
            return 100;
        }
    }

    public static class UpgradeMagic
    extends UpgradeProtective {
        public UpgradeMagic() {
            super("magicProtector", 20);
        }

        @Override
        public boolean shouldDefend(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
            return source.func_82725_o();
        }

        @Override
        public int getEnergyPerDamage(ItemStack stack) {
            return 100;
        }
    }

    public static class UpgradeUnblockable
    extends UpgradeProtective {
        public UpgradeUnblockable() {
            super("unblockableProtector", 10);
        }

        @Override
        public boolean shouldDefend(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
            return source.func_76363_c();
        }

        @Override
        public int getEnergyPerDamage(ItemStack stack) {
            return 100;
        }
    }

    public static class UpgradeExplosion
    extends UpgradeProtective {
        public UpgradeExplosion() {
            super("explosionProtector", 75);
        }

        @Override
        public boolean shouldDefend(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
            return source.func_94541_c();
        }

        @Override
        public int getEnergyPerDamage(ItemStack stack) {
            return 100;
        }
    }

    public static class UpgradeFire
    extends UpgradeProtective {
        public UpgradeFire() {
            super("fireProtector", 75);
        }

        @Override
        public boolean shouldDefend(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
            return source.func_76347_k();
        }

        @Override
        public int getEnergyPerDamage(ItemStack stack) {
            return 100;
        }
    }

    public static class UpgradeProjectileProtection
    extends UpgradeProtective {
        public UpgradeProjectileProtection() {
            super("projectileProtector", 75);
        }

        @Override
        public boolean shouldDefend(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, ArmourSlot slot) {
            return source.func_76352_a();
        }

        @Override
        public int getEnergyPerDamage(ItemStack stack) {
            return 100;
        }
    }
}

