/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.network;

import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Recipe;
import chbachman.api.util.ArmourSlot;
import chbachman.api.util.Array;
import chbachman.armour.network.IContainerSyncable;
import chbachman.armour.network.IInputHandler;
import chbachman.armour.util.MiscUtil;
import cofh.core.network.PacketCoFHBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class ArmourPacket
extends PacketCoFHBase {
    public void handlePacket(EntityPlayer player, boolean isServer) {
        try {
            byte type = this.getByte();
            switch (PacketTypes.values()[type]) {
                case BUTTON: {
                    this.handleButtonPressed(player);
                    break;
                }
                case KEYTYPED: {
                    this.handleKeyTyped(player);
                    break;
                }
                case ENTITYJOINWORLD: {
                    this.handleEntityJoinWorld(player);
                    break;
                }
                case CONTAINERSYNC: {
                    this.handleContainerSync(player);
                    break;
                }
                case RECIPESYNC: {
                    this.handleRecipeSync(player);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArmourPacket getPacket(PacketTypes type) {
        return (ArmourPacket)new ArmourPacket().addByte(type.ordinal());
    }

    public void handleKeyTyped(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof IInputHandler) {
            IInputHandler inputHandler = (IInputHandler)container;
            inputHandler.onKeyTyped(this, (char)this.getShort(), this.getInt());
        }
    }

    public void handleButtonPressed(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof IInputHandler) {
            IInputHandler inputHandler = (IInputHandler)container;
            inputHandler.onButtonClick(this, this.getString());
        }
    }

    public void handleEntityJoinWorld(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null || !(stack.func_77973_b() instanceof IModularItem)) continue;
            IModularItem armour = (IModularItem)stack.func_77973_b();
            for (IUpgrade upgrade : NBTHelper.getNBTUpgradeList(stack.field_77990_d)) {
                upgrade.onEquip(player.field_70170_p, player, stack, ArmourSlot.getArmourSlot(armour.getSlot()));
            }
        }
    }

    public void handleContainerSync(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof IContainerSyncable) {
            IContainerSyncable sync = (IContainerSyncable)container;
            if (MiscUtil.isClient((Entity)player)) {
                sync.clientLoad(this);
            } else {
                sync.serverLoad(this);
            }
        }
    }

    public void handleRecipeSync(EntityPlayer player) {
        Array<Recipe> recipeList = UpgradeRegistry.INSTANCE.recipeList;
        recipeList.clear();
        int size = this.getInt();
        for (int i = 0; i < size; ++i) {
            Object[] recipe = new Object[9];
            for (int g = 0; g < 9; ++g) {
                byte type = this.getByte();
                if (type == 1) {
                    recipe[g] = this.getString();
                }
                if (type == 2) {
                    recipe[g] = this.getItemStack();
                }
                if (type != 3) continue;
                recipe[g] = null;
            }
            UpgradeRegistry.registerRecipe(new Recipe(UpgradeRegistry.getUpgrade(this.getString()), recipe, this.getInt(), this.getInt()));
        }
    }

    public static enum PacketTypes {
        BUTTON,
        KEYTYPED,
        ENTITYJOINWORLD,
        CONTAINERSYNC,
        RECIPESYNC;

    }
}

