/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.items.armour.logic;

import chbachman.api.item.IModularItem;
import chbachman.api.item.UpgradeLogic;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.nbt.helper.NBTList;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.util.ArmourSlot;
import chbachman.armour.ModularArmour;
import chbachman.armour.register.Botania;
import chbachman.armour.register.IndustrialCraft2;
import chbachman.armour.register.Thaumcraft;
import chbachman.armour.util.ConfigHelper;
import cofh.core.util.CoreUtils;
import cpw.mods.fml.common.Optional;
import ic2.api.item.IMetalArmor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.IRevealer;
import vazkii.botania.api.item.IPixieSpawner;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IVisDiscountGear", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft"), @Optional.Interface(iface="vazkii.botania.api.item.IPixieSpawner", modid="Botania"), @Optional.Interface(iface="ic2.api.item.IMetalArmor", modid="IC2")})
public abstract class UpgradeLogicAdv
extends UpgradeLogic
implements IRevealer,
IGoggles,
IVisDiscountGear,
IPixieSpawner,
IMetalArmor {
    public UpgradeLogicAdv(IModularItem item) {
        super(item);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        super.onItemRightClick(stack, world, player);
        if (CoreUtils.isFakePlayer((EntityPlayer)player)) {
            return stack;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)ModularArmour.instance, 0, world, 0, 0, 0);
        }
        return stack;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(itemstack);
        return list.contains(Thaumcraft.gogglesOfRevealing);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(stack);
        if (list.contains(Thaumcraft.visDiscount) && stack.func_77973_b() instanceof IModularItem) {
            IModularItem armour = (IModularItem)stack.func_77973_b();
            switch (ArmourSlot.getArmourSlot(armour.getSlot())) {
                case BELT: {
                    return 4;
                }
                case BOOTS: {
                    return 2;
                }
                case CHESTPLATE: {
                    return 5;
                }
                case HELMET: {
                    return 3;
                }
                case LEGS: {
                    return 4;
                }
                case PENDANT: {
                    return 3;
                }
                case RING: {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(itemstack);
        return list.contains(Thaumcraft.gogglesOfRevealing);
    }

    @Optional.Method(modid="Botania")
    public float getPixieChance(ItemStack stack) {
        return ConfigHelper.get("speed values", Botania.pixie, "Pixie Chance", 0.05f);
    }

    @Optional.Method(modid="IC2")
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(itemstack);
        return list.contains(IndustrialCraft2.metalArmor);
    }

    @Override
    public abstract void healArmour(ItemStack var1, int var2);

    @Override
    public abstract void damageArmour(ItemStack var1, int var2);
}

