/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.handler;

import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.nbt.helper.NBTList;
import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Recipe;
import chbachman.api.util.ImmutableArray;
import chbachman.armour.upgrade.UpgradeException;
import chbachman.armour.util.UpgradeUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class UpgradeHandler {
    public static IUpgrade getResult(IInventory crafting) {
        ImmutableArray<Recipe> array = UpgradeRegistry.getRecipeList();
        for (Recipe recipe : UpgradeRegistry.getRecipeList()) {
            if (!recipe.matches(crafting)) continue;
            return recipe.getCraftingResult();
        }
        return null;
    }

    public static boolean addUpgradeChecked(ItemStack stack, IUpgrade upgrade) {
        try {
            return UpgradeHandler.addUpgrade(stack, upgrade);
        }
        catch (UpgradeException e) {
            return false;
        }
    }

    public static boolean addUpgrade(ItemStack stack, IUpgrade upgrade) {
        NBTHelper.createDefaultStackTag(stack);
        if (stack.func_77973_b() instanceof IModularItem) {
            IModularItem armour = (IModularItem)stack.func_77973_b();
            if (upgrade != null && UpgradeHandler.checkContain(stack, upgrade) && upgrade.isCompatible(armour, stack, armour.getSlot()) && UpgradeHandler.checkDependencies(stack, upgrade)) {
                UpgradeHandler.addUpgradeInternal(stack, upgrade);
                return true;
            }
        }
        return false;
    }

    public static void addUpgradeInternal(ItemStack stack, IUpgrade upgrade) {
        if (upgrade != null) {
            upgrade.onUpgradeAddition((IModularItem)stack.func_77973_b(), stack);
            NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(stack);
            list.add(upgrade);
        }
    }

    public static boolean checkContain(ItemStack stack, IUpgrade upgrade) {
        return !UpgradeUtil.doesItemStackContainUpgrade(stack, upgrade);
    }

    public static boolean checkDependencies(ItemStack stack, IUpgrade iUpgrade) {
        IUpgrade[] dependencies;
        if (iUpgrade == null) {
            return false;
        }
        if (iUpgrade.getDependencies() == null || iUpgrade.getDependencies().length == 0) {
            return true;
        }
        for (IUpgrade dependency : dependencies = iUpgrade.getDependencies()) {
            if (UpgradeUtil.doesItemStackContainUpgrade(stack, dependency)) continue;
            throw new UpgradeException(String.format("This upgrade needs the %s upgrade to work", StatCollector.func_74838_a((String)dependency.getName())), iUpgrade);
        }
        return true;
    }
}

