/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.handler;

import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Recipe;
import chbachman.api.util.ArmourSlot;
import chbachman.armour.handler.PlayerArmour;
import chbachman.armour.network.ArmourPacket;
import chbachman.armour.register.Vanilla;
import chbachman.armour.util.InventoryUtil;
import chbachman.armour.util.MiscUtil;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;

public class GenericEventHandler {
    public static void register() {
        new GenericEventHandler();
    }

    public GenericEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && PlayerArmour.getFor((EntityPlayer)event.entity) == null) {
            EntityPlayer player = (EntityPlayer)event.entity;
            PlayerArmour.register(player);
        }
    }

    @SubscribeEvent
    public void onCraft(PlayerEvent.ItemCraftedEvent e) {
        PlayerArmour storage = PlayerArmour.getFor(e.player);
        if (!storage.hasCraftedArmour && e.crafting.func_77973_b() instanceof IModularItem) {
            storage.hasCraftedArmour = true;
            InventoryUtil.givePlayerItem(e.player, Vanilla.defaultTablet);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        PlayerArmour storage = PlayerArmour.getFor(player);
        ItemStack[] armourList = player.field_71071_by.field_70460_b;
        for (int i = 0; i < armourList.length; ++i) {
            ItemStack playerStack = armourList[i];
            ItemStack storedStack = storage.stacks[i];
            if (InventoryUtil.itemMatches(playerStack, storedStack, false)) continue;
            if (playerStack != null && playerStack.func_77973_b() instanceof IModularItem) {
                ((IModularItem)playerStack.func_77973_b()).onArmourEquip(player.field_70170_p, player, playerStack);
            }
            if (storedStack == null || !(storedStack.func_77973_b() instanceof IModularItem)) continue;
            ((IModularItem)storedStack.func_77973_b()).onArmourDequip(player.field_70170_p, player, storedStack);
        }
        storage.update(armourList);
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent e) {
        for (ItemStack stack : e.player.field_71071_by.field_70460_b) {
            if (stack == null || !(stack.func_77973_b() instanceof IModularItem)) continue;
            NBTHelper.createDefaultStackTag(stack);
            IModularItem armour = (IModularItem)stack.func_77973_b();
            for (IUpgrade upgrade : NBTHelper.getNBTUpgradeList(stack.field_77990_d)) {
                if (upgrade == null) continue;
                upgrade.onEquip(e.player.field_70170_p, e.player, stack, ArmourSlot.getArmourSlot(armour.getSlot()));
            }
        }
        if (MiscUtil.isServer((Entity)e.player)) {
            ArmourPacket packet = ArmourPacket.getPacket(ArmourPacket.PacketTypes.RECIPESYNC);
            packet.addInt(UpgradeRegistry.getRecipeList().size());
            for (Recipe recipe : UpgradeRegistry.getRecipeList()) {
                for (Object obj : recipe.getInput()) {
                    if (obj instanceof String) {
                        packet.addByte(1);
                        packet.addString((String)obj);
                        continue;
                    }
                    if (obj instanceof ItemStack) {
                        packet.addByte(2);
                        packet.addItemStack((ItemStack)obj);
                        continue;
                    }
                    if (obj != null) continue;
                    packet.addByte(3);
                }
                packet.addString(recipe.getRecipeOutput().getBaseName());
                packet.addInt(recipe.width);
                packet.addInt(recipe.height);
            }
            PacketHandler.sendTo((PacketBase)packet, (EntityPlayer)e.player);
        }
    }
}

