/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.gui.element;

import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.nbt.helper.NBTList;
import chbachman.api.upgrade.IUpgrade;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementListBox;
import cofh.lib.gui.element.listbox.IListBoxElement;
import cofh.lib.gui.element.listbox.ListBoxElementText;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public abstract class ElementUpgradeListBox
extends ElementListBox {
    public ElementUpgradeListBox(GuiBase containerScreen, int x, int y, int width, int height) {
        super(containerScreen, x, y, width, height);
    }

    public void loadStack(ItemStack stack) {
        this.removeAll();
        NBTList<IUpgrade> textLines = NBTHelper.getNBTUpgradeList(stack);
        for (IUpgrade upgrade : textLines) {
            this.add(upgrade);
        }
    }

    public void add(IUpgrade upgrade) {
        this.add((IListBoxElement)new ListBoxElementUpgrade(upgrade));
    }

    protected void onSelectionChanged(int newIndex, IListBoxElement newElement) {
        this.onUpgradeSelected(this.getUpgrade(newElement), newIndex);
    }

    public IUpgrade getSelectedUpgrade() {
        return this.getUpgrade(this.getSelectedElement());
    }

    private IUpgrade getUpgrade(IListBoxElement element) {
        return ((ListBoxElementUpgrade)element).upgrade;
    }

    public abstract void onUpgradeSelected(IUpgrade var1, int var2);

    private static class ListBoxElementUpgrade
    extends ListBoxElementText {
        private final IUpgrade upgrade;

        public ListBoxElementUpgrade(IUpgrade upgrade) {
            super(StatCollector.func_74838_a((String)upgrade.getName()));
            this.upgrade = upgrade;
        }
    }
}

