/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.gui.crafting;

import chbachman.api.configurability.Percentage;
import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.nbt.helper.NBTStorage;
import chbachman.api.nbt.serializers.PercentageNBT;
import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.armour.ModularArmour;
import chbachman.armour.handler.UpgradeHandler;
import chbachman.armour.network.ArmourPacket;
import chbachman.armour.network.IContainerSyncable;
import chbachman.armour.network.IInputHandler;
import chbachman.armour.upgrade.UpgradeException;
import chbachman.armour.util.InventoryUtil;
import chbachman.armour.util.MiscUtil;
import chbachman.armour.util.UpgradeUtil;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.gui.container.ContainerInventoryItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ArmourContainer
extends ContainerInventoryItem
implements IInputHandler,
IContainerSyncable {
    public IUpgrade upgrade = null;
    public final IModularItem item;
    NBTStorage<Percentage> storage = new NBTStorage<Percentage>(new PercentageNBT());

    public ArmourContainer(ItemStack stack, InventoryPlayer inventory) {
        super(stack, inventory);
        this.item = (IModularItem)stack.func_77973_b();
        this.bindCraftingGrid();
        this.bindPlayerInventory(inventory);
    }

    protected void bindCraftingGrid() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.containerWrapper, i * 3 + j, 183 + j * 18, 152 + i * 18));
            }
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 152 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 210));
        }
    }

    public void onSlotChanged() {
        super.onSlotChanged();
        this.upgrade = UpgradeHandler.getResult((IInventory)this.containerWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onButtonClick(ArmourPacket packet, String name) {
        boolean shouldSync = false;
        try {
            if (name.equals("UpgradeAddition")) {
                if (UpgradeHandler.addUpgrade(this.getContainerStack(), this.upgrade)) {
                    this.upgrade = UpgradeHandler.getResult((IInventory)this.containerWrapper);
                    for (int i = 0; i < this.containerWrapper.func_70302_i_(); ++i) {
                        InventoryUtil.decrementItemStack(this.player, (IInventory)this.containerWrapper, i);
                    }
                    shouldSync = true;
                }
            } else if (name.equals("RemoveItems")) {
                shouldSync = true;
                for (int i = 0; i < 9; ++i) {
                    this.func_82846_b(this.player, i);
                }
            } else if (name.equals("RemoveUpgrade")) {
                UpgradeUtil.removeUpgrade(this.getContainerStack(), UpgradeRegistry.getUpgrade(packet.getString()));
                shouldSync = true;
            } else if (name.equals("Recipe")) {
                if (MiscUtil.isServer(this.player.field_70170_p)) {
                    this.player.openGui((Object)ModularArmour.instance, 1, this.player.field_70170_p, 0, 0, 0);
                }
            } else if (name.equals("ValueChanged")) {
                NBTHelper.createDefaultStackTag(this.getContainerStack());
                this.storage.setKey(packet.getString());
                this.storage.set(this.getContainerStack(), new Percentage(packet.getInt()));
            }
        }
        catch (UpgradeException e) {
        }
        finally {
            this.player.field_71071_by.field_70462_a[this.containerIndex] = this.getContainerStack();
        }
        if (shouldSync) {
            this.func_75142_b();
            PacketHandler.sendTo((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.CONTAINERSYNC).addItemStack(this.getContainerStack()), (EntityPlayer)this.player);
        }
    }

    @Override
    public void onKeyTyped(ArmourPacket packet, char key, int keyCode) {
    }

    @Override
    public void clientLoad(ArmourPacket p) {
        ItemStack container = p.getItemStack();
        this.getContainerStack().field_77990_d = container.field_77990_d;
    }

    @Override
    public void serverLoad(ArmourPacket p) {
    }
}

