/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour;

import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.armour.gui.GuiHandler;
import chbachman.armour.handler.DamageEventHandler;
import chbachman.armour.handler.GenericEventHandler;
import chbachman.armour.proxy.IProxy;
import chbachman.armour.register.ItemRegister;
import chbachman.armour.util.ModularCreativeTab;
import chbachman.armour.util.OutputHandler;
import chbachman.armour.util.json.JsonRegister;
import cofh.core.network.PacketHandler;
import cofh.core.util.ConfigHandler;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ModularArmour", name="Modular Armour", version="1.0.0", dependencies="after:Thaumcraft;after:ThermalExpansion;after:Baubles;after:Botania;after:AWWayOfTime;after:MineTweaker3")
public class ModularArmour {
    @Mod.Instance(value="ModularArmour")
    public static ModularArmour instance;
    @SidedProxy(clientSide="chbachman.armour.proxy.ClientProxy", serverSide="chbachman.armour.proxy.ServerProxy")
    public static IProxy proxy;
    public static final boolean developmentEnvironment;
    public static Logger log;
    public static GuiHandler guiHandler;
    public static ConfigHandler config;
    public static OutputHandler output;
    private static File configDir;
    public static ModularCreativeTab creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory(), "ModularArmour");
        configDir.mkdir();
        config.setConfiguration(new Configuration(new File(configDir, "Main.cfg")));
        output = new OutputHandler(new File(configDir, "ModularRecipes.txt"));
        creativeTab = new ModularCreativeTab();
        ItemRegister.INSTANCE.preInit();
        proxy.registerKeyBinds();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (developmentEnvironment) {
            MinecraftForge.EVENT_BUS.register((Object)new DamageEventHandler());
        }
        GenericEventHandler.register();
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        ItemRegister.INSTANCE.init();
        for (IUpgrade upgrade : UpgradeRegistry.getUpgradeList()) {
            upgrade.registerConfigOptions();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        proxy.registerKeyBinds();
        proxy.registerPacketInformation();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        config.cleanUp(false, true);
        ItemRegister.INSTANCE.postInit();
        output.save();
        PacketHandler.instance.postInit();
        GsonBuilder gsonBuilder = new GsonBuilder();
        JsonRegister.registerCustomSerializers(gsonBuilder);
        JsonRegister.createJsonRecipes(gsonBuilder);
        JsonRegister.registerJsonRecipes(gsonBuilder);
    }

    public static File getConfigDirectory() {
        return configDir;
    }

    static {
        developmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        log = LogManager.getLogger((String)"ModularArmour");
        guiHandler = new GuiHandler();
        config = new ConfigHandler("1.0.0");
    }
}

