/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobdbb;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.aobd.blocks.AOBDBlock;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobdbb.AOBDBB;
import ganymedes01.aobdbb.BerryBushAddon;
import ganymedes01.aobdbb.configuration.BerryBushConfigs;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class AOBDBBBushBlock
extends AOBDBlock
implements IPlantable,
IGrowable {
    public static final int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static final int MAX_GROWTH_META = 7;
    @SideOnly(value=Side.CLIENT)
    private IIcon fancy;
    @SideOnly(value=Side.CLIENT)
    private IIcon fast;
    @SideOnly(value=Side.CLIENT)
    private IIcon berry;
    @SideOnly(value=Side.CLIENT)
    private IIcon berryOverlay;
    public RenderingStage renderingStage = RenderingStage.BUSH;
    private final Item berryItem;
    private final Ore ore;

    public AOBDBBBushBlock(Item berry, String base, Ore ore) {
        super(Material.field_151584_j, base, ore);
        this.ore = ore;
        this.berryItem = berry;
        this.func_149711_c(0.3f);
        this.func_149675_a(true);
        this.setHarvestLevel("axe", 2);
        this.func_149672_a(field_149779_h);
        this.func_149663_c("aobdbb." + base + ore);
        this.func_149658_d("aobdbb:" + base);
    }

    protected String getFullName() {
        return "tile.aobdbb." + this.base + this.ore.name() + ".name";
    }

    protected String getShortName() {
        return "tile.aobdbb." + this.base + ".name";
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        BerryBushConfigs config;
        int meta;
        if (world.func_72957_l(x, y + 1, z) < 9 && (meta = world.func_72805_g(x, y, z)) <= 7 && (config = BerryBushAddon.bushMap.get(this.ore)) != null && rand.nextDouble() < config.getGrowthChance()) {
            world.func_72921_c(x, y, z, ++meta, 2);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            return super.func_149742_c(world, x, y, z);
        }
        return false;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return world.func_72805_g(x, y, z) >= 7;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList drops = super.getDrops(world, x, y, z, meta, fortune);
        if (meta > 7) {
            drops.add(new ItemStack(this.berryItem));
        }
        return drops;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 7) {
            this.addToPlayerInventory(player, new ItemStack(this.berryItem), x, y, z);
            if (!player.field_71075_bZ.field_75098_d) {
                world.func_72921_c(x, y, z, 7, 2);
            }
            return true;
        }
        return false;
    }

    private void addToPlayerInventory(EntityPlayer player, ItemStack stack, double x, double y, double z) {
        if (!player.field_70170_p.field_72995_K) {
            EntityItem entity = new EntityItem(player.field_70170_p, x + 0.5, y, z + 0.5, stack);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_145804_b = 0;
            player.field_70170_p.func_72838_d((Entity)entity);
            entity.func_70100_b_(player);
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        return world.func_72805_g(x, y, z) != 7;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        world.func_72921_c(x, y, z, Math.min(7, world.func_72805_g(x, y, z) + 1), 2);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return this.func_149741_i(world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        switch (this.renderingStage) {
            case BERRY: {
                return this.ore.colour();
            }
            case BUSH: {
                BerryBushConfigs config = BerryBushAddon.bushMap.get(this.ore);
                return config.getBushColour();
            }
            case BERRY_OVERLAY: {
                return this.ore.getColour().darker().darker().getRGB();
            }
        }
        return 0xFFFFFF;
    }

    public int func_149645_b() {
        return RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        if (world.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) < 7) {
            return true;
        }
        return Blocks.field_150362_t.func_149662_c() && world.func_147439_a(x, y, z) == this && world.func_72805_g(x, y, z) >= 7 ? false : super.func_149646_a(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (this.renderingStage) {
            case BERRY: {
                return this.berry;
            }
            case BERRY_OVERLAY: {
                return this.berryOverlay;
            }
        }
        return Blocks.field_150362_t.func_149662_c() ? this.fast : this.fancy;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = Math.min(7, world.func_72805_g(x, y, z) + 1);
        float rate = (float)meta / 7.0f;
        float t = (1.0f - rate) / 2.0f;
        this.func_149676_a(t, 0.0f, t, rate + t, rate, rate + t);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (AOBDBB.doBushesPrick && entity instanceof EntityLivingBase) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.fancy = reg.func_94245_a(this.func_149641_N() + "_fancy");
        this.fast = reg.func_94245_a(this.func_149641_N() + "_fast");
        this.berry = reg.func_94245_a(this.func_149641_N() + "_berries");
        this.berryOverlay = reg.func_94245_a(this.func_149641_N() + "_berries_overlay");
    }

    public static enum RenderingStage {
        BUSH,
        BERRY,
        BERRY_OVERLAY;

    }
}

