/*
 * Decompiled with CFR 0.152.
 */
package com.raizunne.redstonic.Item;

import cofh.api.energy.IEnergyContainerItem;
import com.raizunne.redstonic.Redstonic;
import com.raizunne.redstonic.Util.Util;
import cpw.mods.fml.common.Loader;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemBattery
extends Item
implements IEnergyContainerItem {
    int type;
    IIcon[] icons;

    public ItemBattery(int type) {
        this.type = type;
        this.func_77656_e(80);
        this.func_77655_b(this.func_77658_a());
        this.func_77625_d(1);
        this.func_77637_a(Redstonic.redTab);
    }

    public void func_77663_a(ItemStack stack, World world, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("Energy", 0);
            stack.field_77990_d.func_74768_a("maxEnergy", this.getMaxEnergy());
            this.fixDamage(stack);
        } else {
            if (stack.field_77990_d.func_74762_e("Energy") > this.getMaxEnergy()) {
                stack.field_77990_d.func_74768_a("Energy", this.getMaxEnergy());
            }
            if (stack.field_77990_d.func_74762_e("maxEnergy") == 0) {
                stack.field_77990_d.func_74768_a("maxEnergy", this.getMaxEnergy());
            }
        }
    }

    public void func_77622_d(ItemStack stack, World p_77622_2_, EntityPlayer p_77622_3_) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("Energy", 0);
            stack.field_77990_d.func_74768_a("maxEnergy", this.getMaxEnergy());
            this.fixDamage(stack);
        } else {
            this.fixDamage(stack);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer p_77624_2_, List list, boolean p_77624_4_) {
        NBTTagCompound nbt = stack.field_77990_d;
        if (nbt != null) {
            int Energy = nbt.func_74762_e("Energy");
            list.add(EnumChatFormatting.GREEN + "Energy: " + EnumChatFormatting.GRAY + (this.getMaxEnergy() == -1 ? EnumChatFormatting.OBFUSCATED + "9001" : NumberFormat.getNumberInstance(Locale.US).format(Energy)) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + "/" + (this.getMaxEnergy() == -1 ? "Creative" : NumberFormat.getNumberInstance(Locale.US).format(this.getMaxEnergy())) + " RF");
            if (Keyboard.isKeyDown((int)42)) {
                list.add(EnumChatFormatting.DARK_AQUA + "Max Input: " + EnumChatFormatting.GRAY + NumberFormat.getNumberInstance(Locale.US).format(this.getMaxInput()) + " RF/t");
                list.add(EnumChatFormatting.DARK_AQUA + "Max Output: " + EnumChatFormatting.GRAY + NumberFormat.getNumberInstance(Locale.US).format(this.getMaxOutput()) + " RF/t");
            } else {
                list.add(Util.ItemShiftInfo);
            }
        } else {
            list.add("Tier " + this.getTier());
            list.add("Max Energy: " + (this.getMaxEnergy() == -1 ? EnumChatFormatting.OBFUSCATED + "9001" : NumberFormat.getNumberInstance(Locale.US).format(this.getMaxEnergy())));
            if (!Loader.isModLoaded((String)"EnderIO") && this.type != 0) {
                list.add("Missing mod" + EnumChatFormatting.DARK_AQUA + " EnderIO");
            }
        }
    }

    public String func_77658_a() {
        switch (this.type) {
            case 0: {
                return "basicBattery";
            }
            case 1: {
                return "energizedBattery";
            }
            case 2: {
                return "greatBattery";
            }
            case 3: {
                return "infiniteBattery";
            }
        }
        return "unknownBattery";
    }

    public int getMaxEnergy() {
        switch (this.type) {
            case 0: {
                return 500000;
            }
            case 1: {
                return 5000000;
            }
            case 2: {
                return 25000000;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    public int getMaxOutput() {
        switch (this.type) {
            case 0: {
                return 8000;
            }
            case 1: {
                return 16000;
            }
            case 2: {
                return 48000;
            }
            case 3: {
                return 64000000;
            }
        }
        return 0;
    }

    public int getMaxInput() {
        switch (this.type) {
            case 0: {
                return 8000;
            }
            case 1: {
                return 16000;
            }
            case 2: {
                return 48000;
            }
            case 3: {
                return 64000000;
            }
        }
        return 1;
    }

    public int getTier() {
        switch (this.type) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 9001;
            }
        }
        return 0;
    }

    public void func_94581_a(IIconRegister i) {
        this.icons = new IIcon[4];
        this.icons[0] = i.func_94245_a("redstonic:Material/Battery/BasicBattery");
        this.icons[1] = i.func_94245_a("redstonic:Material/Battery/EnergizedBattery");
        this.icons[2] = i.func_94245_a("redstonic:Material/Battery/GreatBattery");
        this.icons[3] = i.func_94245_a("redstonic:Material/Battery/InfiniteBattery");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.icons[this.type];
    }

    public IIcon func_77650_f(ItemStack p_77650_1_) {
        return this.icons[this.type];
    }

    public void fixDamage(ItemStack stack) {
        double modifier = 80.0 / (double)this.getMaxEnergy();
        if (this.getMaxEnergy() != -1) {
            stack.func_77964_b((int)(80.0 - (double)stack.field_77990_d.func_74762_e("Energy") * modifier));
        } else {
            stack.func_77964_b(0);
        }
    }

    public void takeEnergy(ItemStack stack, int i) {
        stack.field_77990_d.func_74768_a("Energy", stack.field_77990_d.func_74762_e("Energy") - i);
        double modifier = 80.0 / (double)stack.field_77990_d.func_74762_e("maxEnergy");
        stack.func_77964_b((int)(80.0 - (double)stack.field_77990_d.func_74762_e("Energy") * modifier));
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int maxEnergy = container.field_77990_d.func_74762_e("maxEnergy");
        int energyReceived = Math.min(maxEnergy - energy, Math.min(this.getMaxInput(), maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        this.fixDamage(container);
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.getMaxEnergy(), maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        this.fixDamage(container);
        return energyExtracted;
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        try {
            return container.field_77990_d.func_74762_e("Energy");
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        try {
            return container.field_77990_d.func_74762_e("maxEnergy");
        }
        catch (NullPointerException e) {
            return 0;
        }
    }
}

