/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.pack;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.jaquadro.minecraft.storagedrawers.api.pack.TextureType;
import net.minecraft.creativetab.CreativeTabs;

public class StandardDataResolver
implements IPackDataResolver {
    private String modID;
    private String[] unlocalizedNames;
    private CreativeTabs creativeTab;

    public StandardDataResolver(String modID, String[] unlocalizedNames) {
        this.modID = modID;
        this.unlocalizedNames = unlocalizedNames;
    }

    public StandardDataResolver(String modID, String[] unlocalizedNames, CreativeTabs creativeTab) {
        this(modID, unlocalizedNames);
        this.creativeTab = creativeTab;
    }

    @Override
    public String getPackModID() {
        return this.modID;
    }

    protected String makeBlockName(String name) {
        return this.getPackModID().toLowerCase() + "." + name;
    }

    @Override
    public String getBlockName(BlockConfiguration blockConfig) {
        switch (blockConfig.getBlockType()) {
            case Drawers: 
            case DrawersSorting: {
                if (blockConfig.getDrawerCount() == 1) {
                    return this.makeBlockName("fullDrawers1");
                }
                if (blockConfig.getDrawerCount() == 2 && !blockConfig.isHalfDepth()) {
                    return this.makeBlockName("fullDrawers2");
                }
                if (blockConfig.getDrawerCount() == 4 && !blockConfig.isHalfDepth()) {
                    return this.makeBlockName("fullDrawers4");
                }
                if (blockConfig.getDrawerCount() == 2 && blockConfig.isHalfDepth()) {
                    return this.makeBlockName("halfDrawers2");
                }
                if (blockConfig.getDrawerCount() != 4 || !blockConfig.isHalfDepth()) break;
                return this.makeBlockName("halfDrawers4");
            }
            case Trim: {
                return this.makeBlockName("trim");
            }
        }
        return null;
    }

    @Override
    public CreativeTabs getCreativeTabs(BlockType type) {
        return this.creativeTab;
    }

    @Override
    public boolean isValidMetaValue(int meta) {
        if (meta < 0 || meta >= this.unlocalizedNames.length) {
            return false;
        }
        return this.unlocalizedNames != null && this.unlocalizedNames[meta] != null;
    }

    @Override
    public String getUnlocalizedName(int meta) {
        if (!this.isValidMetaValue(meta)) {
            return null;
        }
        return this.unlocalizedNames[meta];
    }

    protected String getBaseTexturePath() {
        return this.getPackModID() + ":";
    }

    protected String getTextureMetaName(int meta) {
        return this.getUnlocalizedName(meta);
    }

    @Override
    public String getTexturePath(TextureType type, int meta) {
        switch (type) {
            case Front1: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_front_1";
            }
            case Front2: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_front_2";
            }
            case Front4: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_front_4";
            }
            case Side: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_side";
            }
            case SideSort: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_sort";
            }
            case SideVSplit: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_side_v";
            }
            case SideHSplit: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_side_h";
            }
            case TrimBorder: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_trim";
            }
            case TrimBlock: {
                return this.getBaseTexturePath() + "drawers_" + this.getTextureMetaName(meta) + "_side";
            }
        }
        return "";
    }
}

