/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.generators.common.GeneratorsPacketHandler;
import mekanism.generators.common.MekanismGenerators;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketGeneratorsGui
implements IMessageHandler<GeneratorsGuiMessage, IMessage> {
    public IMessage onMessage(GeneratorsGuiMessage message, MessageContext context) {
        EntityPlayer player = GeneratorsPacketHandler.getPlayer(context);
        if (!player.field_70170_p.field_72995_K) {
            WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
            if (worldServer != null && message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityBasicBlock) {
                if (message.guiId == -1) {
                    return null;
                }
                GeneratorsGuiMessage.openServerGui(message.guiId, (EntityPlayerMP)player, player.field_70170_p, message.coord4D);
            }
        } else {
            FMLCommonHandler.instance().showGuiScreen((Object)GeneratorsGuiMessage.getGui(message.guiId, player, player.field_70170_p, message.coord4D));
            player.field_71070_bA.field_75152_c = message.windowId;
        }
        return null;
    }

    public static class GeneratorsGuiMessage
    implements IMessage {
        public Coord4D coord4D;
        public int guiId;
        public int windowId;

        public GeneratorsGuiMessage() {
        }

        public GeneratorsGuiMessage(Coord4D coord, int gui) {
            this.coord4D = coord;
            this.guiId = gui;
        }

        public GeneratorsGuiMessage(Coord4D coord, int gui, int id) {
            this(coord, gui);
            this.windowId = id;
        }

        public static void openServerGui(int id, EntityPlayerMP playerMP, World world, Coord4D obj) {
            playerMP.func_71128_l();
            playerMP.func_71117_bO();
            int window = playerMP.field_71139_cq;
            MekanismGenerators.packetHandler.sendTo(new GeneratorsGuiMessage(obj, id, window), playerMP);
            playerMP.field_71070_bA = MekanismGenerators.proxy.getServerGui(id, (EntityPlayer)playerMP, world, obj.xCoord, obj.yCoord, obj.zCoord);
            playerMP.field_71070_bA.field_75152_c = window;
            playerMP.field_71070_bA.func_75132_a((ICrafting)playerMP);
        }

        @SideOnly(value=Side.CLIENT)
        public static GuiScreen getGui(int id, EntityPlayer player, World world, Coord4D obj) {
            return (GuiScreen)MekanismGenerators.proxy.getClientGui(id, player, world, obj.xCoord, obj.yCoord, obj.zCoord);
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            dataStream.writeInt(this.guiId);
            dataStream.writeInt(this.windowId);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.guiId = dataStream.readInt();
            this.windowId = dataStream.readInt();
        }
    }
}

