/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.wiiemc.version;

import com.google.gson.Gson;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.lomeli.wiiemc.core.helper.Logger;
import net.lomeli.wiiemc.version.UpdateJson;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class VersionChecker {
    private int mod_major;
    private int mod_minor;
    private int mod_rev;
    private boolean needsUpdate;
    private boolean isDirect;
    private boolean doneTelling;
    private String version;
    private String downloadURL;
    private String jsonURL;
    private String modname;
    private String currentVer;
    private String[] changeList;

    public VersionChecker(String jsonURL, String modname, int major, int minor, int rev) {
        this.jsonURL = jsonURL;
        this.modname = modname;
        this.mod_major = major;
        this.mod_minor = minor;
        this.mod_rev = rev;
        this.currentVer = this.mod_major + "." + this.mod_minor + "." + this.mod_rev;
        this.needsUpdate = false;
        this.isDirect = false;
        this.doneTelling = true;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void checkForUpdates() {
        try {
            Logger.logInfo("Checking for updates...");
            URL url = new URL(this.jsonURL);
            Gson gson = new Gson();
            UpdateJson update = (UpdateJson)gson.fromJson((Reader)new InputStreamReader(url.openStream()), UpdateJson.class);
            if (update != null) {
                this.needsUpdate = true;
                if (this.mod_major >= update.getMajor()) {
                    if (this.mod_minor >= update.getMinor()) {
                        if (this.mod_rev >= update.getRevision()) {
                            this.needsUpdate = false;
                        } else if (this.mod_minor >= update.getMinor()) {
                            this.needsUpdate = this.mod_major < update.getMajor();
                        }
                    } else {
                        boolean bl = this.needsUpdate = this.mod_major < update.getMajor();
                    }
                }
                if (this.needsUpdate) {
                    this.downloadURL = update.getDownloadURL();
                    this.isDirect = update.isDirect();
                    this.changeList = update.getChangeLog();
                    this.version = update.getVersion();
                    this.doneTelling = false;
                    this.sendMessage();
                } else {
                    Logger.logInfo("Using latest version of " + this.modname);
                }
            }
        }
        catch (Exception e) {
            Logger.logError("Could not check for updates for " + this.modname + "!");
        }
    }

    private String translate(String unlocalized) {
        return StatCollector.func_74838_a((String)unlocalized);
    }

    private void sendMessage() {
        if (Loader.isModLoaded((String)"VersionChecker")) {
            String changeLog = "";
            for (String i : this.changeList) {
                changeLog = changeLog + "- " + i;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("modDisplayName", this.modname);
            tag.func_74778_a("oldVersion", this.currentVer);
            tag.func_74778_a("newVersion", this.version);
            tag.func_74778_a("updateUrl", this.downloadURL);
            tag.func_74757_a("isDirectLink", this.isDirect);
            tag.func_74778_a("changeLog", changeLog);
            FMLInterModComms.sendMessage((String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)tag);
        }
        Logger.logInfo(String.format(this.translate("update.wiiemc"), this.version, this.downloadURL));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && FMLClientHandler.instance().getClient().field_71439_g != null) {
            EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
            if (!this.doneTelling) {
                player.func_146105_b((IChatComponent)new ChatComponentText(String.format(this.translate("update.wiiemc"), this.version, this.downloadURL)));
                this.doneTelling = true;
            }
        }
    }
}

