/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.wiiemc.providers;

import com.pahimar.ee3.api.exchange.EnergyValue;
import cpw.mods.fml.common.Loader;
import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.lomeli.simplecondenser.lib.enums.RedstoneState;
import net.lomeli.simplecondenser.tile.TileCondenserBase;
import net.lomeli.wiiemc.config.ModConfig;
import net.lomeli.wiiemc.core.helper.ObfUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class TileEMCDataProvider
implements IWailaDataProvider {
    private static DecimalFormat energyValueDecimalFormat = new DecimalFormat("###,###,###,###,###.###");

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        if (tile != null) {
            if (this.isTransmutationTablet(tile) && ModConfig.showTabletEMC) {
                EnergyValue value = this.getTabletAvailableEnergyValue(tile);
                if (value != null) {
                    String text = StatCollector.func_74838_a((String)"tooltip.wiiemc.energy.availableemc");
                    String emc = energyValueDecimalFormat.format(value.getValue());
                    tooltip.add(String.format(text, emc));
                }
            } else if (Loader.isModLoaded((String)"simplecondenser") && tile instanceof TileCondenserBase) {
                String text;
                TileCondenserBase condenser = (TileCondenserBase)tile;
                EnergyValue value = condenser.getStoredEnergyValue();
                if (ModConfig.showCondenserEMC && value != null) {
                    text = StatCollector.func_74838_a((String)"tooltip.wiiemc.energy.storedemc");
                    String emc = energyValueDecimalFormat.format(value.getValue());
                    tooltip.add(String.format(text, emc));
                }
                if (ModConfig.showCondenserRate) {
                    text = StatCollector.func_74838_a((String)"tooltip.wiiemc.condenser.tickrate");
                    tooltip.add(String.format(text, condenser.getType().getSpeed()));
                }
                if (ModConfig.showCondenserRedstoneState) {
                    text = StatCollector.func_74838_a((String)"tooltip.wiiemc.condenser.redstone.ignore");
                    RedstoneState state = condenser.getRedstoneState();
                    if (state == RedstoneState.HIGH) {
                        text = StatCollector.func_74838_a((String)"tooltip.wiiemc.condenser.redstone.on");
                    } else if (state == RedstoneState.LOW) {
                        text = StatCollector.func_74838_a((String)"tooltip.wiiemc.condenser.redstone.off");
                    }
                    tooltip.add(text);
                }
            }
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public boolean isTransmutationTablet(TileEntity tile) {
        try {
            Class<?> clazz = Class.forName("com.pahimar.ee3.tileentity.TileEntityTransmutationTablet");
            return clazz.isInstance(tile);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public EnergyValue getTabletAvailableEnergyValue(Object obj) {
        try {
            Class<?> clazz = Class.forName("com.pahimar.ee3.tileentity.TileEntityTransmutationTablet");
            EnergyValue value = (EnergyValue)ObfUtil.getFieldValue(clazz, obj, "availableEnergyValue");
            return value != null ? value : new EnergyValue(0.0f);
        }
        catch (Exception exception) {
            return new EnergyValue(0.0f);
        }
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        try {
            Class<?> condenserClass;
            Class<?> tabletClass = Class.forName("com.pahimar.ee3.tileentity.TileEntityTransmutationTablet");
            if (tabletClass != null) {
                registrar.registerBodyProvider((IWailaDataProvider)new TileEMCDataProvider(), tabletClass);
            }
            if (Loader.isModLoaded((String)"simplecondenser") && (condenserClass = Class.forName("net.lomeli.simplecondenser.tile.TileCondenserBase")) != null) {
                registrar.registerBodyProvider((IWailaDataProvider)new TileEMCDataProvider(), condenserClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

