/*
 * Decompiled with CFR 0.152.
 */
package particlephysics.utility;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import particlephysics.ParticlePhysics;
import particlephysics.proxy.ClientProxy;
import particlephysics.utility.IBlock;

public abstract class BasicComplexBlock
extends Block
implements IBlock {
    public IIcon connectorIcon;
    public IIcon topIcon;
    static int blockIdIncrement;
    public String textureBase = "particlephysics:";

    public abstract String getFront();

    public abstract String getTop();

    public boolean func_149686_d() {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean hasModel() {
        return false;
    }

    public BasicComplexBlock(Material material) {
        super(material);
        this.func_149663_c(this.getName());
    }

    public BasicComplexBlock() {
        super(Material.field_151573_f);
        this.func_149663_c(this.getName());
    }

    @Override
    public boolean inCreativeTab() {
        return true;
    }

    public abstract void addStacksDroppedOnBlockBreak(TileEntity var1, ArrayList<ItemStack> var2);

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMetadata) {
        Random random = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            ArrayList<ItemStack> droppedStacks = new ArrayList<ItemStack>();
            this.addStacksDroppedOnBlockBreak(tileEntity, droppedStacks);
            for (ItemStack itemstack : droppedStacks) {
                float randomX = random.nextFloat() * 0.8f + 0.1f;
                float randomY = random.nextFloat() * 0.8f + 0.1f;
                float randomZ = random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int randomN = random.nextInt(21) + 10;
                    if (randomN > itemstack.field_77994_a) {
                        randomN = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= randomN;
                    ItemStack droppedStack = new ItemStack(itemstack.func_77973_b(), randomN, itemstack.func_77960_j());
                    if (itemstack.func_77942_o()) {
                        droppedStack.func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    EntityItem droppedEntityItem = new EntityItem(world, (double)((float)x + randomX), (double)((float)y + randomY), (double)((float)z + randomZ), droppedStack);
                    world.func_72838_d((Entity)droppedEntityItem);
                }
            }
            super.func_149749_a(world, x, y, z, oldBlock, oldMetadata);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        if (this.hasModel()) {
            return ClientProxy.RENDER_ID;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a(this.textureBase + this.getFront());
        this.topIcon = par1IconRegister.func_94245_a(this.textureBase + this.getTop());
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.topSidedTextures() && (side == 1 || side == 0)) {
            return this.topIcon;
        }
        return this.field_149761_L;
    }

    public void func_149689_a(World par1World, int x, int y, int z, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
                break;
            }
            case 3: {
                change = 3;
            }
        }
        par1World.func_72921_c(x, y, z, change, 2);
        par1World.func_147459_d(x, y, z, (Block)this);
    }

    public TileEntity createTileEntity(World var1, int metadata) {
        try {
            return this.getTileEntityClass().newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            ParticlePhysics.LOGGER.fatal("Error while creating tile entity");
            return null;
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.getTileEntityClass() != null;
    }

    @Override
    public void addRecipe() {
    }

    @Override
    public String getName() {
        return "BasicComplexBlock";
    }

    @Override
    public boolean hasItemBlock() {
        return false;
    }

    @Override
    public Class getItemBlock() {
        return ItemBlock.class;
    }

    public boolean topSidedTextures() {
        return true;
    }

    @Override
    public Class<TileEntity> getTileEntityClass() {
        return null;
    }

    public boolean isPlantMaterial() {
        return false;
    }
}

