/*
 * Decompiled with CFR 0.152.
 */
package particlephysics.tileentity.emitter;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import particlephysics.entity.particle.BlankParticle;
import particlephysics.entity.particle.BlazepowderParticle;
import particlephysics.entity.particle.ClayParticle;
import particlephysics.entity.particle.CoalParticle;
import particlephysics.entity.particle.GlassParticle;
import particlephysics.entity.particle.GunpowderParticle;
import particlephysics.entity.particle.LeafParticle;
import particlephysics.entity.particle.PaperParticle;
import particlephysics.entity.particle.SandParticle;
import particlephysics.entity.particle.SeedParticle;
import particlephysics.entity.particle.TemplateParticle;
import particlephysics.tileentity.infiniteemitter.InfiniteEmitterBlock;

public class EmitterTileEntity
extends TileEntity
implements IInventory {
    public int interval = 40;
    public ItemStack[] inventory = new ItemStack[7];
    public ItemStack fuelType;
    public int fuelStored = 0;
    public int intervalReset = 0;

    public void func_145845_h() {
        this.pushQueue();
        this.intervalReset = (int)(this.field_145850_b.func_82737_E() % (long)(20 * this.interval + 20));
        if (!this.field_145850_b.field_72995_K && this.intervalReset == 0) {
            if (this.fuelStored < 1 && this.inventory != null && this.inventory[0] != null && this.isValidFuel(this.inventory[0])) {
                this.fuelStored = 100;
                this.fuelType = this.inventory[0].func_77946_l();
                this.func_70298_a(0, 1);
            }
            if (this.fuelStored > 0) {
                ForgeDirection[] outputDirections;
                if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof InfiniteEmitterBlock) || this.func_70301_a(0) == null || this.func_70301_a((int)0).field_77994_a < 63) {
                    this.fuelStored -= 4;
                }
                for (ForgeDirection dir : outputDirections = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.EAST}) {
                    TemplateParticle particle = this.getParticleFromFuel(this.fuelType);
                    if (particle == null) {
                        return;
                    }
                    particle.func_70024_g(dir.offsetX, dir.offsetY, dir.offsetZ);
                    particle.func_70107_b((double)(this.field_145851_c + dir.offsetX) + 0.375, (double)(this.field_145848_d + dir.offsetY) + 0.375, (double)(this.field_145849_e + dir.offsetZ) + 0.375);
                    this.field_145850_b.func_72838_d((Entity)particle);
                }
            }
        }
    }

    protected void pushQueue() {
        for (int i = this.inventory.length - 1; i >= 0; --i) {
            if (i == 0 || this.inventory[i] == null) continue;
            if (this.inventory[i - 1] == null) {
                this.func_70299_a(i - 1, this.inventory[i]);
                this.func_70299_a(i, null);
                continue;
            }
            if (!this.inventory[i - 1].func_77969_a(this.inventory[i])) continue;
            int spaceLeft = this.inventory[i - 1].func_77976_d() - this.inventory[i - 1].field_77994_a;
            if (spaceLeft >= this.inventory[i].field_77994_a) {
                this.inventory[i - 1].field_77994_a += this.inventory[i].field_77994_a;
                this.inventory[i] = null;
                continue;
            }
            this.inventory[i - 1].field_77994_a += spaceLeft;
            this.inventory[i].field_77994_a -= spaceLeft;
        }
    }

    public TemplateParticle getParticleFromFuel(ItemStack fuel) {
        if (fuel.func_77973_b() == Items.field_151044_h) {
            return new CoalParticle(this.field_145850_b);
        }
        if (fuel.func_77973_b() == Items.field_151065_br) {
            return new BlazepowderParticle(this.field_145850_b);
        }
        if (fuel.func_77973_b() == Items.field_151119_aD) {
            return new ClayParticle(this.field_145850_b);
        }
        if (fuel.func_77973_b() == Items.field_151016_H) {
            return new GunpowderParticle(this.field_145850_b);
        }
        if (fuel.func_77973_b() == Items.field_151014_N) {
            return new SeedParticle(this.field_145850_b);
        }
        if (fuel.func_77973_b() == Items.field_151121_aF) {
            return new PaperParticle(this.field_145850_b);
        }
        if (fuel.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
            return new SandParticle(this.field_145850_b);
        }
        if (fuel.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150362_t)) {
            return new LeafParticle(this.field_145850_b);
        }
        if (fuel.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150359_w)) {
            return new GlassParticle(this.field_145850_b);
        }
        return new BlankParticle(this.field_145850_b);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.interval = nbt.func_74762_e("Interval");
        this.fuelStored = nbt.func_74762_e("Fuel");
        if (nbt.func_74764_b("FuelType")) {
            this.fuelType = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("FuelType"));
        }
        NBTTagList tagList = nbt.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            int slot = compound.func_74762_e("Slot");
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Interval", this.interval);
        nbt.func_74768_a("Fuel", this.fuelStored);
        if (this.fuelType != null) {
            nbt.func_74782_a("FuelType", (NBTBase)this.fuelType.func_77955_b(new NBTTagCompound()));
        }
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Slot", i);
            item.func_77955_b(compound);
            tagList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Inventory", (NBTBase)tagList);
    }

    public int func_70302_i_() {
        return 7;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack itemstack = this.func_70301_a(i);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                itemstack = itemstack.func_77979_a(j);
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        this.func_70299_a(i, null);
        return item;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
    }

    public String func_145825_b() {
        return "emitter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.isValidFuel(itemstack);
    }

    public boolean isValidFuel(ItemStack fuel) {
        if (fuel.func_77973_b() == Items.field_151044_h) {
            return true;
        }
        if (fuel.func_77973_b() == Items.field_151065_br) {
            return true;
        }
        if (fuel.func_77973_b() == Items.field_151119_aD) {
            return true;
        }
        if (fuel.func_77973_b() == Items.field_151016_H) {
            return true;
        }
        if (fuel.func_77973_b() == Items.field_151014_N) {
            return true;
        }
        if (fuel.func_77973_b() == Items.field_151121_aF) {
            return true;
        }
        if (fuel.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
            return true;
        }
        if (fuel.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150362_t)) {
            return true;
        }
        return fuel.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150359_w);
    }

    public void receiveButton(int type, int value) {
        switch (type) {
            case 0: {
                switch (value) {
                    case 0: {
                        this.fuelStored = 0;
                    }
                }
            }
            case 1: {
                this.interval = value;
            }
        }
    }

    public void setFuelData(int id, int value) {
        int stackSize;
        int damage = this.fuelType == null ? 0 : this.fuelType.func_77960_j();
        int n = stackSize = this.fuelType == null ? 0 : this.fuelType.field_77994_a;
        if (this.fuelType != null) {
            if (id == 1) {
                this.fuelType = value == 0 ? null : new ItemStack(Item.func_150899_d((int)value), stackSize, damage);
            } else if (id == 2) {
                this.fuelType = new ItemStack(this.fuelType.func_77973_b(), stackSize, value);
            }
        }
    }
}

