/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.util.singletons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.DimensionManager;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.util.ChunkIntPairSerializable;

public class ClaimedChunks {
    private static final String fileName = String.valueOf(DimensionManager.getCurrentSaveRootDirectory()) + "/" + "sanguimancy" + "/ClaimedChunks.dat";
    private static ClaimedChunks claimedChunks;
    private HashMap<String, ArrayList<ChunkIntPairSerializable>> chunks;

    private ClaimedChunks() {
    }

    public static ClaimedChunks getClaimedChunks() {
        if (claimedChunks == null) {
            claimedChunks = new ClaimedChunks();
            claimedChunks.loadFile();
        }
        if (ClaimedChunks.claimedChunks.chunks == null) {
            ClaimedChunks.claimedChunks.chunks = new HashMap();
            claimedChunks.updateFile();
        }
        return claimedChunks;
    }

    private void loadFile() {
        HashMap map = null;
        File file = new File(fileName);
        try {
            if (!file.exists()) {
                if (file.getParentFile().mkdir()) {
                    if (file.createNewFile()) {
                        Sanguimancy.logger.info("Creating " + fileName + " in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
                    }
                } else if (file.createNewFile()) {
                    Sanguimancy.logger.info("Creating " + fileName + " in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
                } else {
                    throw new IOException("Failed to create directory " + file.getParent());
                }
            }
            FileInputStream fileIn = new FileInputStream(file);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            map = (HashMap)in.readObject();
            in.close();
            fileIn.close();
            this.chunks = map;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            Sanguimancy.logger.error(String.valueOf(file) + " was not found in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
        }
    }

    private void updateFile() {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.chunks);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean addLocation(String name, ChunkIntPairSerializable location) {
        ArrayList<ChunkIntPairSerializable> chunkLocation = this.chunks.get(name);
        if (chunkLocation == null) {
            this.chunks.put(name, new ArrayList());
            this.updateFile();
        }
        for (String string : this.chunks.keySet()) {
            if (!this.chunks.get(string).contains(location)) continue;
            Sanguimancy.logger.info("Chunk already claimed by: " + string);
            this.updateFile();
            return false;
        }
        this.chunks.get(name).add(location);
        Sanguimancy.logger.info(name + " claiming chunk");
        this.updateFile();
        return true;
    }

    public boolean removeLocation(String name, ChunkIntPairSerializable location) {
        if (this.chunks.get(name) != null && !this.chunks.get(name).isEmpty()) {
            if (this.chunks.get(name).contains(location)) {
                this.chunks.get(name).remove(location);
                Sanguimancy.logger.info("Removing " + name);
                this.updateFile();
                return true;
            }
            Sanguimancy.logger.info("No claimed chunk matching " + name);
            this.updateFile();
            return false;
        }
        return false;
    }

    public ArrayList<ChunkIntPairSerializable> getLinkedChunks(String name) {
        if (this.chunks.get(name) == null) {
            this.chunks.put(name, new ArrayList());
        }
        return this.chunks.get(name);
    }
}

