/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.tile;

import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.LifeEssenceNetwork;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import tombenpotter.sanguimancy.api.objects.Timer;
import tombenpotter.sanguimancy.api.tile.TileComputerBase;
import tombenpotter.sanguimancy.compat.lua.events.LuaOrbMaxed;
import tombenpotter.sanguimancy.compat.lua.methods.LuaGetLifeEssence;
import tombenpotter.sanguimancy.compat.lua.methods.LuaGetOrbMax;
import tombenpotter.sanguimancy.compat.lua.methods.LuaGetOwner;
import tombenpotter.sanguimancy.network.PacketHandler;
import tombenpotter.sanguimancy.network.packets.PacketBloodInterfaceUpdate;
import tombenpotter.sanguimancy.registry.BlocksRegistry;

public class TileBloodInterface
extends TileComputerBase
implements IInventory {
    private ItemStack itemStack;
    private int maxOrbLP = 0;
    private int redstone = 0;
    private String ownerName = null;
    private Timer redstoneUpdate = new Timer(5);
    private NBTTagCompound custoomNBTTag;

    public TileBloodInterface() {
        super("BloodInterface");
        this.addMethod(new LuaGetLifeEssence());
        this.addMethod(new LuaGetOrbMax());
        this.addMethod(new LuaGetOwner());
        this.custoomNBTTag = new NBTTagCompound();
    }

    private void triggerUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public String getType() {
        return "blood_interface";
    }

    public int getLifeEssence() {
        if (this.ownerName == null || this.itemStack == null) {
            return 0;
        }
        return Math.min(this.maxOrbLP, this.getCurrentEssence(this.itemStack));
    }

    public String getOwner() {
        return this.ownerName;
    }

    public int getOrbMax() {
        return this.maxOrbLP;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return slot == 0 ? this.itemStack : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void breakInterface() {
        if (!this.field_145850_b.field_72995_K && this.itemStack != null) {
            float spawnX = (float)this.field_145851_c + 0.5f;
            float spawnY = (float)this.field_145848_d + 0.5f;
            float spawnZ = (float)this.field_145849_e + 0.5f;
            EntityItem droppedItem = new EntityItem(this.field_145850_b, (double)spawnX, (double)spawnY, (double)spawnZ, this.itemStack);
            this.field_145850_b.func_72838_d((Entity)droppedItem);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public void serverUpdate() {
        super.serverUpdate();
        if (this.redstoneUpdate.update()) {
            this.updateRedstone();
        }
    }

    @Override
    public void init() {
        super.init();
        this.addEvent(new LuaOrbMaxed(), 5);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot == 0) {
            this.itemStack = itemStack;
            this.updateOrb();
            this.updateRedstone();
            this.func_70296_d();
        }
    }

    public void updateOrb() {
        this.maxOrbLP = this.itemStack == null ? 0 : ((IBloodOrb)this.itemStack.func_77973_b()).getMaxEssence();
        this.ownerName = this.itemStack == null || !this.itemStack.func_77942_o() || !this.itemStack.func_77978_p().func_74764_b("ownerName") ? null : this.itemStack.func_77978_p().func_74779_i("ownerName");
    }

    public void updateRedstone() {
        int result = this.calcRedstone();
        if (result != this.redstone) {
            this.redstone = result;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlocksRegistry.bloodInterface);
            }
        }
    }

    public int calcRedstone() {
        if (this.itemStack == null || this.maxOrbLP == 0) {
            return 0;
        }
        return 15 * this.getLifeEssence() / this.maxOrbLP;
    }

    public String func_145825_b() {
        return this.getType();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            PacketBloodInterfaceUpdate message = new PacketBloodInterfaceUpdate(this);
            PacketHandler.INSTANCE.sendToAll((IMessage)message);
        }
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        NBTTagCompound itemTag;
        if (this.itemStack != null && itemStack != null) {
            return false;
        }
        if (this.itemStack != null && itemStack == null) {
            return true;
        }
        NBTTagCompound nBTTagCompound = itemTag = itemStack != null ? itemStack.field_77990_d : null;
        if (itemTag == null || !itemTag.func_74764_b("ownerName") || itemTag.func_74779_i("ownerName").equals("")) {
            return false;
        }
        return slot == 0 && itemStack.func_77973_b() instanceof IBloodOrb;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagCompound item = compound.func_74775_l("Item");
        if (item != null) {
            this.itemStack = ItemStack.func_77949_a((NBTTagCompound)item);
            this.updateOrb();
            this.updateRedstone();
        }
        this.custoomNBTTag = compound.func_74775_l("customNBTTag");
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.itemStack != null) {
            compound.func_74782_a("Item", (NBTBase)this.itemStack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("customNBTTag", (NBTBase)this.custoomNBTTag);
    }

    public int getComparatorLevel() {
        return this.redstone;
    }

    public Packet func_145844_m() {
        this.func_145841_b(new NBTTagCompound());
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new PacketBloodInterfaceUpdate(this));
    }

    @Override
    public NBTTagCompound getCustomNBTTag() {
        return this.custoomNBTTag;
    }

    @Override
    public void setCustomNBTTag(NBTTagCompound tag) {
        this.custoomNBTTag = tag;
    }

    public int getCurrentEssence(ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return 0;
        }
        NBTTagCompound itemTag = par1ItemStack.func_77978_p();
        if (itemTag == null || itemTag.func_74779_i("ownerName").equals("")) {
            return 0;
        }
        WorldServer worldSave = MinecraftServer.func_71276_C().field_71305_c[0];
        String owner = itemTag.func_74779_i("ownerName");
        LifeEssenceNetwork data = (LifeEssenceNetwork)worldSave.func_72943_a(LifeEssenceNetwork.class, owner);
        if (data == null) {
            data = new LifeEssenceNetwork(owner);
            worldSave.func_72823_a(owner, (WorldSavedData)data);
        }
        int currentEssence = data.currentEssence;
        return currentEssence;
    }
}

