/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.tile.TileBloodTank;
import tombenpotter.sanguimancy.util.RandomUtils;

public class BlockBloodTank
extends BlockContainer {
    public static int renderId = 10000;
    public static int[] capacities = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65336, 131072, 262144, 524288};

    public BlockBloodTank(Material material) {
        super(material);
        this.func_149711_c(5.0f);
        this.func_149647_a(Sanguimancy.tabSanguimancy);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileBloodTank(capacities[metadata]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("sanguimancy:BloodTank");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TileBloodTank fluidHandler = (TileBloodTank)world.func_147438_o(x, y, z);
        if (RandomUtils.fillHandlerWithContainer(world, fluidHandler, player)) {
            world.func_147471_g(x, y, z);
            return true;
        }
        if (RandomUtils.fillContainerFromHandler(world, fluidHandler, player, fluidHandler.tank.getFluid())) {
            world.func_147471_g(x, y, z);
            return true;
        }
        if (FluidContainerRegistry.isContainer((ItemStack)player.func_71045_bC())) {
            world.func_147471_g(x, y, z);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, p_149727_6_, p_149727_7_, p_149727_8_, p_149727_9_);
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        this.func_149697_b(world, x, y, z, meta, 0);
        super.func_149681_a(world, x, y, z, meta, player);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (world.func_147438_o(x, y, z) instanceof TileBloodTank) {
            TileBloodTank tile = (TileBloodTank)world.func_147438_o(x, y, z);
            ItemStack drop = new ItemStack((Block)this, 1, metadata);
            NBTTagCompound tag = new NBTTagCompound();
            tile.func_145841_b(tag);
            drop.field_77990_d = tag;
            list.add(drop);
        }
        return list;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack stack) {
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileBloodTank) {
            TileBloodTank tile = (TileBloodTank)world.func_147438_o(x, y, z);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                tile.func_145839_a(tag);
            }
        }
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBloodTank) {
            TileBloodTank tank = (TileBloodTank)tile;
            FluidStack fluid = tank.tank.getFluid();
            if (fluid != null) {
                return fluid.getFluid().getLuminosity(fluid);
            }
        }
        return 0;
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileBloodTank) {
            TileBloodTank tank = (TileBloodTank)tile;
            FluidStack fluid = tank.tank.getFluid();
            if (fluid != null) {
                return fluid.getFluid().getColor(fluid);
            }
        }
        return 0xFFFFFF;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = 0;
        if (side == 6 || side == 7) {
            meta = 1;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileBloodTank) {
                TileBloodTank tank = (TileBloodTank)tile;
                FluidStack fluid = tank.tank.getFluid();
                if (fluid != null) {
                    return fluid.getFluid().getIcon(fluid);
                }
            }
        }
        return this.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List list) {
        for (int i = 0; i <= 15; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }
}

