/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.dynamicgui;

import com.rwtema.extrautils.dynamicgui.DynamicContainer;
import com.rwtema.extrautils.dynamicgui.DynamicGui;
import com.rwtema.extrautils.dynamicgui.IWidget;
import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.helper.XUHelperClient;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;

public class WidgetTank
implements IWidget {
    public static final int[] ux2 = new int[]{18, 18, 18};
    public static final int[] uy2 = new int[]{0, 0, 0};
    public static final int[] uw2 = new int[]{7, 7, 7};
    public static final int[] uh2 = new int[]{64, 64, 64};
    public static final int[] ux = new int[]{32, 0, 50};
    public static final int[] uy = new int[]{0, 0, 0};
    public static final int[] uw = new int[]{18, 18, 18};
    public static final int[] uh = new int[]{33, 18, 65};
    FluidStack curFluid = null;
    int curCapacity = 0;
    FluidTankInfo tankInfo;
    int shape;
    int x;
    int y;

    public WidgetTank(FluidTankInfo tankInfo, int x, int y) {
        this(tankInfo, x, y, 0);
    }

    public WidgetTank(FluidTankInfo tankInfo, int x, int y, int shape) {
        this.tankInfo = tankInfo;
        this.shape = shape;
        this.x = x;
        this.y = y;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderLiquid(FluidStack fluid, TextureManager manager, DynamicGui gui, int x, int y, int w, int h) {
        if (fluid == null) {
            return;
        }
        if (w == 0 || h == 0) {
            return;
        }
        manager.func_110577_a(fluid.getFluid().getSpriteNumber() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
        int color = fluid.getFluid().getColor(fluid);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        IIcon icon = fluid.getFluid().getIcon(fluid);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int dx1 = x; dx1 < x + w; dx1 += 16) {
            for (int dy1 = y; dy1 < y + h; dy1 += 16) {
                int dx2 = Math.min(dx1 + 16, x + w);
                int dy2 = Math.min(dy1 + 16, y + h);
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)dx1, (double)dy2, (double)gui.getZLevel(), (double)icon.func_94209_e(), (double)(icon.func_94206_g() + (icon.func_94210_h() - icon.func_94206_g()) * (float)(dy2 - dy1) / 16.0f));
                tessellator.func_78374_a((double)dx2, (double)dy2, (double)gui.getZLevel(), (double)(icon.func_94209_e() + (icon.func_94212_f() - icon.func_94209_e()) * (float)(dx2 - dx1) / 16.0f), (double)(icon.func_94206_g() + (icon.func_94210_h() - icon.func_94206_g()) * (float)(dy2 - dy1) / 16.0f));
                tessellator.func_78374_a((double)dx2, (double)dy1, (double)gui.getZLevel(), (double)(icon.func_94209_e() + (icon.func_94212_f() - icon.func_94209_e()) * (float)(dx2 - dx1) / 16.0f), (double)icon.func_94206_g());
                tessellator.func_78374_a((double)dx1, (double)dy1, (double)gui.getZLevel(), (double)icon.func_94209_e(), (double)icon.func_94206_g());
                tessellator.func_78381_a();
            }
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getW() {
        return uw[this.shape];
    }

    @Override
    public int getH() {
        return uh[this.shape];
    }

    @Override
    public NBTTagCompound getDescriptionPacket(boolean changesOnly) {
        FluidStack newFluid = this.tankInfo.fluid;
        if (changesOnly && this.curCapacity == this.tankInfo.capacity && (this.curFluid == null ? newFluid == null : this.curFluid.isFluidEqual(newFluid) && newFluid.amount == this.curFluid.amount)) {
            return null;
        }
        this.curFluid = newFluid != null ? newFluid.copy() : null;
        this.curCapacity = this.tankInfo.capacity;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("capacity", this.curCapacity);
        if (this.curFluid != null) {
            this.curFluid.writeToNBT(tag);
        }
        return tag;
    }

    @Override
    public void handleDescriptionPacket(NBTTagCompound packet) {
        this.curCapacity = packet.func_74762_e("capacity");
        this.curFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)packet);
    }

    @Override
    public NBTTagCompound getPlayerInputPacket() {
        return null;
    }

    @Override
    public void handlePlayerInputPacket(NBTTagCompound packet) {
    }

    @Override
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.curFluid != null && this.curFluid.getFluid() != null && this.curCapacity > 0) {
            int a = this.curFluid.amount * (this.getH() - 2) / this.curCapacity;
            WidgetTank.renderLiquid(this.curFluid, manager, gui, guiLeft + this.getX() + 1, guiTop + this.getY() - 1 + this.getH() - a, this.getW() - 2, a);
        }
        manager.func_110577_a(gui.getWidgets());
        gui.func_73729_b(guiLeft + this.getX() + this.getW() - uw2[this.shape] - 1, guiTop + this.getY() + 1, ux2[this.shape] + uw2[this.shape], uy2[this.shape], uw2[this.shape], Math.min(this.getH() - 2, uh2[this.shape]));
        gui.func_73729_b(guiLeft + this.getX() + 1, guiTop + this.getY() + 1, ux2[this.shape], uy2[this.shape], uw2[this.shape], Math.min(this.getH() - 2, uh2[this.shape]));
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        manager.func_110577_a(gui.getWidgets());
        gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), ux[this.shape], uy[this.shape], uw[this.shape], uh[this.shape]);
    }

    @Override
    public void addToContainer(DynamicContainer container) {
    }

    @Override
    public List<String> getToolTip() {
        if (this.curCapacity > 0) {
            ArrayList<String> l = new ArrayList<String>();
            if (this.curFluid == null) {
                l.add("0 / " + XUHelperClient.commaDelimited(this.curCapacity));
            } else {
                l.add(XUHelper.getFluidName(this.curFluid) + ": " + XUHelperClient.commaDelimited(this.curFluid.amount) + " / " + XUHelperClient.commaDelimited(this.curCapacity));
            }
            return l;
        }
        return null;
    }
}

