/*
 * Decompiled with CFR 0.152.
 */
package difficultLife.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import difficultLife.init.DLConfigSetup;
import difficultLife.init.DLItems;
import difficultLife.network.DataSyncManager;
import difficultLife.utils.DLSaveStorage;
import difficultLife.utils.DLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;

public class DLEventHandler {
    public static List<DLPotionEntry> potions = new ArrayList<DLPotionEntry>();

    public static void initPotions() {
        potions.add(new DLPotionEntry(Potion.field_76420_g.field_76415_H, 30));
        potions.add(new DLPotionEntry(Potion.field_76424_c.field_76415_H, 10));
        potions.add(new DLPotionEntry(Potion.field_76426_n.field_76415_H, 10));
        potions.add(new DLPotionEntry(Potion.field_76441_p.field_76415_H, 20));
        potions.add(new DLPotionEntry(Potion.field_76429_m.field_76415_H, 30));
    }

    public static DLPotionEntry findRandPotion(Random rnd, float maxWeight) {
        ArrayList<DLPotionEntry> lst = new ArrayList<DLPotionEntry>();
        for (int i = 0; i < potions.size(); ++i) {
            DLPotionEntry e = potions.get(i);
            if (!(e.weight <= maxWeight)) continue;
            lst.add(e);
        }
        if (!lst.isEmpty()) {
            return (DLPotionEntry)lst.get(rnd.nextInt(lst.size()));
        }
        return null;
    }

    @SubscribeEvent
    public void livingDropsEvent(LivingDropsEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K) {
            if (event.recentlyHit && event.entityLiving.field_70170_p.field_73012_v.nextFloat() <= DLConfigSetup.HEART_DROP_CHANCE) {
                event.entityLiving.func_145779_a(DLItems.heart, 1);
            }
            if (event.entityLiving instanceof EntityWither && DLConfigSetup.GAIN_HEARTS_FROM_WITHER) {
                event.entityLiving.func_145779_a(DLItems.heart, 3 + event.entityLiving.field_70170_p.field_73012_v.nextInt(3));
            }
            if (event.entityLiving instanceof EntityDragon && DLConfigSetup.GAIN_HEARTS_FROM_DRAGON) {
                event.entityLiving.func_145779_a(DLItems.heart, 9 + event.entityLiving.field_70170_p.field_73012_v.nextInt(12));
            }
        }
    }

    @SubscribeEvent
    public void livingSpawnEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entityLiving.field_70170_p.field_72995_K || event.entityLiving instanceof EntityPlayer || EntityList.func_75621_b((Entity)event.entityLiving) == null || EntityList.func_75621_b((Entity)event.entityLiving).isEmpty() || DLConfigSetup.PERMITTED_FROM_HP_INCREASEMENT.contains(EntityList.func_75621_b((Entity)event.entityLiving)) || event.entityLiving.func_110140_aT() == null || event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(DLUtils.modifierID) != null)) {
            DLPotionEntry e;
            float diffIncrease;
            float difficulty = DLSaveStorage.commonGenericTag.func_74760_g("difficulty");
            if (!DLConfigSetup.PERMITTED_FROM_BLIGHT.contains(EntityList.func_75621_b((Entity)event.entityLiving)) && event.entityLiving.field_70170_p.field_73012_v.nextFloat() < DLSaveStorage.commonGenericTag.func_74760_g("difficulty") / DLConfigSetup.DIFFICULTY_MAX * DLConfigSetup.BLIGHT_CHANCE_MULTIPLIER) {
                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, Integer.MAX_VALUE, 0, true));
                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, true));
                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, Integer.MAX_VALUE, 8, true));
                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, Integer.MAX_VALUE, 2, true));
                if (event.entityLiving instanceof EntityLiving) {
                    EntityLiving entity = (EntityLiving)event.entityLiving;
                    int i = event.entity.field_70170_p.field_73012_v.nextInt(2);
                    float f = 0.5f;
                    if (event.entity.field_70170_p.field_73012_v.nextFloat() < 0.095f) {
                        ++i;
                    }
                    if (event.entity.field_70170_p.field_73012_v.nextFloat() < 0.095f) {
                        ++i;
                    }
                    if (event.entity.field_70170_p.field_73012_v.nextFloat() < 0.095f) {
                        ++i;
                    }
                    for (int j = 3; j >= 0; --j) {
                        Item item;
                        ItemStack itemstack = entity.func_130225_q(j);
                        if (j < 3 && event.entity.field_70170_p.field_73012_v.nextFloat() < f) break;
                        if (itemstack != null || (item = EntityLiving.func_82161_a((int)(j + 1), (int)i)) == null) continue;
                        entity.func_70062_b(j + 1, new ItemStack(item));
                    }
                }
                for (int i = 0; i < 5; ++i) {
                    ItemStack is = event.entityLiving.func_71124_b(i);
                    if (is == null) continue;
                    is = EnchantmentHelper.func_77504_a((Random)event.entityLiving.field_70170_p.field_73012_v, (ItemStack)is, (int)30);
                }
                event.entityLiving.func_70015_d(0x6666666);
                if (event.entityLiving instanceof EntityCreeper) {
                    ((EntityCreeper)event.entityLiving).func_70077_a(new EntityLightningBolt(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v));
                }
                difficulty *= 3.0f;
            }
            float genAddedHealth = difficulty;
            genAddedHealth = event.entityLiving instanceof IMob ? (genAddedHealth *= DLConfigSetup.DIFFICULTY_GENERIC_HEALTH_MULTIPLIER) : (genAddedHealth *= DLConfigSetup.DIFFICULTY_PEACEFULL_HEALTH_MULTIPLIER);
            difficulty -= genAddedHealth;
            if (difficulty > 0.0f) {
                float randomFlt = event.entityLiving.field_70170_p.field_73012_v.nextFloat();
                diffIncrease = difficulty * randomFlt;
                difficulty -= diffIncrease;
                genAddedHealth += diffIncrease;
            }
            if (event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111264_e) != null && difficulty > 0.0f) {
                float randomFlt = event.entityLiving.field_70170_p.field_73012_v.nextFloat();
                diffIncrease = difficulty * randomFlt;
                difficulty -= diffIncrease;
                if (event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111127_a(DLUtils.modifierID) == null) {
                    event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(DLUtils.modifierID, "DL.damageMod", (double)(diffIncrease / 10.0f), 0));
                }
            }
            if (difficulty > 0.0f && (e = DLEventHandler.findRandPotion(event.entityLiving.field_70170_p.field_73012_v, difficulty)) != null) {
                difficulty -= e.weight;
            }
            if (event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(DLUtils.modifierID) == null) {
                event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(DLUtils.modifierID, "DL.healthMod", (double)genAddedHealth, 0));
            }
            event.entityLiving.func_70606_j(event.entityLiving.func_110138_aP());
        }
        if (!event.entityLiving.field_70170_p.field_72995_K && event.entityLiving instanceof EntityPlayer && DLConfigSetup.ENABLE_CUSTOM_HEALTH_REGEN && event.entityLiving.field_70170_p.func_72820_D() % 240L == 0L && ((EntityPlayer)event.entityLiving).func_71024_bL().func_75116_a() >= 10) {
            event.entityLiving.func_70691_i(1.0f);
        }
        if (!event.entityLiving.field_70170_p.field_72995_K && event.entityLiving instanceof EntityPlayer && event.entityLiving.field_70173_aa % 20 == 0) {
            EntityPlayer p = (EntityPlayer)event.entityLiving;
            List players = p.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(p.field_70165_t - 0.5), (double)(p.field_70163_u - 0.5), (double)(p.field_70161_v - 0.5), (double)(p.field_70165_t + 0.5), (double)(p.field_70163_u + 0.5), (double)(p.field_70161_v + 0.5)).func_72314_b(16.0, 8.0, 16.0));
            for (EntityPlayer pl : players) {
                NBTTagCompound tag = DLSaveStorage.playerData.get(p.func_70005_c_());
                if (!tag.func_74764_b("username")) {
                    tag.func_74778_a("username", p.func_70005_c_());
                }
                DataSyncManager.requestServerToClientMessage("playerData", (EntityPlayerMP)pl, tag, true);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.world != null && event.world.field_73011_w != null && event.world.field_73011_w.field_76574_g == 0 && event.phase == TickEvent.Phase.START) {
            float dIncrease = 0.0f;
            if (event.world.func_72820_D() % 20L == 0L) {
                dIncrease = DLConfigSetup.DIFFICULTY_EACH_TICK;
            }
            DLSaveStorage.manageDifficultyIncrease(dIncrease);
        }
        if (DLConfigSetup.ENABLE_CUSTOM_HEALTH_REGEN) {
            event.world.func_82736_K().func_82764_b("naturalRegeneration", "false");
        }
    }

    @SubscribeEvent
    public void onPlayerConstruction(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            NBTTagCompound tag;
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            float maxHealth = player.func_110138_aP();
            if (DLConfigSetup.LOOSE_HEALTH_ON_DEATH && (tag = DLSaveStorage.playerData.get(player.func_70005_c_())) != null && !tag.func_82582_d()) {
                tag.func_74768_a("health", DLConfigSetup.PLAYER_HEARTS_GENERIC * 2);
                DLSaveStorage.playerData.put(player.func_70005_c_(), tag);
                DataSyncManager.requestServerToClientMessage("playerData", player, DLSaveStorage.playerData.get(player.func_70005_c_()), true);
            }
            float shouldHave = DLSaveStorage.getSuggestedAmmoundOfHealthForPlayer((EntityPlayer)player);
            float difference = maxHealth - shouldHave;
            AttributeModifier mod = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(DLUtils.modifierID);
            if (mod == null) {
                player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(DLUtils.modifierID, "DL.playerhealthDifference", (double)(-difference), 0));
            }
            maxHealth = player.func_110138_aP();
            if (player.func_110143_aJ() > maxHealth) {
                player.func_70606_j(maxHealth);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerReadedFromFile(PlayerEvent.LoadFromFile event) {
        DLSaveStorage.generatePlayerSaveFile(event);
    }

    @SubscribeEvent
    public void onPlayerSavedToFile(PlayerEvent.SaveToFile event) {
        DLSaveStorage.saveServerPlayerFile(event);
    }

    @SubscribeEvent
    public void onPlayerJoinedServerEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            DataSyncManager.requestServerToClientMessage("worldData", (EntityPlayerMP)event.player, DLSaveStorage.commonGenericTag, true);
            DataSyncManager.requestServerToClientMessage("playerData", (EntityPlayerMP)event.player, DLSaveStorage.playerData.get(event.player.func_70005_c_()), true);
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            float maxHealth = player.func_110138_aP();
            float shouldHave = DLSaveStorage.getSuggestedAmmoundOfHealthForPlayer((EntityPlayer)player);
            float difference = maxHealth - shouldHave;
            AttributeModifier mod = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(DLUtils.modifierID);
            if (mod == null) {
                player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(DLUtils.modifierID, "DL.playerhealthDifference", (double)(-difference), 0));
            }
            maxHealth = player.func_110138_aP();
            if (player.func_110143_aJ() > maxHealth) {
                player.func_70606_j(maxHealth);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoadEvent(WorldEvent.Load event) {
        DLSaveStorage.generateServerWorldFile(event);
    }

    @SubscribeEvent
    public void onWorldSaveEvent(WorldEvent.Save event) {
        DLSaveStorage.saveServerWorldFile(event);
    }

    public static class DLPotionEntry {
        float weight;
        int potionID;

        public DLPotionEntry(float f, int i) {
            this.weight = f;
            this.potionID = i;
        }
    }
}

