/*
 * Decompiled with CFR 0.152.
 */
package difficultLife.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class ClientHeartDisplayManager {
    public static final int[] colors = new int[]{0xB80000, 12206095, 16733981, 13540864, 11256832, 3968512, 2540841, 575330, 905935, 38086, 1270706, 1260466, 5996524, 0x6F6FEF, 7427526, 9328070, 12268520, 0xE833E8, 15353240, 15353240, 0xFFFFFF};
    public static int updateCounter = 0;
    public static final ResourceLocation heartTextures = new ResourceLocation("difficultlife", "textures/health.png");
    public static final ResourceLocation icons = new ResourceLocation("textures/gui/icons.png");
    public static final Random rand = new Random();
    double zLevel = 0.0;

    @SubscribeEvent
    public void renderHealthbar(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HEALTH) {
            boolean highlight;
            ++updateCounter;
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int scaledWidth = scaledresolution.func_78326_a();
            int scaledHeight = scaledresolution.func_78328_b();
            int xBasePos = scaledWidth / 2 - 91;
            int yBasePos = scaledHeight - 39;
            boolean bl = highlight = mc.field_71439_g.field_70172_ad / 3 % 2 == 1;
            if (mc.field_71439_g.field_70172_ad < 10) {
                highlight = false;
            }
            IAttributeInstance attrMaxHealth = mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111267_a);
            int health = MathHelper.func_76123_f((float)mc.field_71439_g.func_110143_aJ());
            int healthLast = MathHelper.func_76123_f((float)mc.field_71439_g.field_70735_aL);
            float healthMax = (float)attrMaxHealth.func_111126_e();
            if (healthMax > 20.0f) {
                healthMax = 20.0f;
            }
            float absorb = mc.field_71439_g.func_110139_bj();
            int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            rand.setSeed(updateCounter * 312871);
            int left = scaledWidth / 2 - 91;
            int top = scaledHeight - GuiIngameForge.left_height;
            if (!GuiIngameForge.renderExperiance) {
                top += 7;
                yBasePos += 7;
            }
            int regen = -1;
            if (mc.field_71439_g.func_70644_a(Potion.field_76428_l)) {
                regen = updateCounter % 25;
            }
            float absorbRemaining = absorb;
            int TOP = 9 * (mc.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
            int BACKGROUND = highlight ? 25 : 16;
            int MARGIN = 16;
            if (mc.field_71439_g.func_70644_a(Potion.field_76436_u)) {
                MARGIN += 36;
            } else if (mc.field_71439_g.func_70644_a(Potion.field_82731_v)) {
                MARGIN += 72;
            }
            for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
                boolean b0 = highlight;
                int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
                int x = left + i % 10 * 8;
                int y = top - row * rowHeight;
                if (health <= 4) {
                    y += rand.nextInt(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                this.drawTexturedModalRect(x, y, BACKGROUND, TOP, 9, 9, 0xFFFFFF);
                if (highlight) {
                    if (i * 2 + 1 < healthLast) {
                        this.drawTexturedModalRect(x, y, MARGIN + 54, TOP, 9, 9, 0xFFFFFF);
                    } else if (i * 2 + 1 == healthLast) {
                        this.drawTexturedModalRect(x, y, MARGIN + 63, TOP, 9, 9, 0xFFFFFF);
                    }
                }
                if (absorbRemaining > 0.0f) {
                    if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                        this.drawTexturedModalRect(x, y, MARGIN + 153, TOP, 9, 9, 0xFFFFFF);
                    } else {
                        this.drawTexturedModalRect(x, y, MARGIN + 144, TOP, 9, 9, 0xFFFFFF);
                    }
                    absorbRemaining -= 2.0f;
                    continue;
                }
                if (i * 2 + 1 < health) {
                    this.drawTexturedModalRect(x, y, MARGIN + 36, TOP, 9, 9, 0xFFFFFF);
                    continue;
                }
                if (i * 2 + 1 != health) continue;
                this.drawTexturedModalRect(x, y, MARGIN + 45, TOP, 9, 9, 0xFFFFFF);
            }
            int potionOffset = 0;
            PotionEffect potion = mc.field_71439_g.func_70660_b(Potion.field_82731_v);
            if (potion != null) {
                potionOffset = 18;
            }
            if ((potion = mc.field_71439_g.func_70660_b(Potion.field_76436_u)) != null) {
                potionOffset = 9;
            }
            if (mc.field_71441_e.func_72912_H().func_76093_s()) {
                potionOffset += 27;
            }
            mc.func_110434_K().func_110577_a(heartTextures);
            int hp = MathHelper.func_76123_f((float)mc.field_71439_g.func_110143_aJ());
            for (int iter = 0; iter < hp / 20; ++iter) {
                int renderHearts = (hp - 20 * (iter + 1)) / 2;
                if (renderHearts > 10) {
                    renderHearts = 10;
                }
                for (int i = 0; i < renderHearts; ++i) {
                    int y = 0;
                    if (i == regen) {
                        y -= 2;
                    }
                    this.drawTexturedModalRect(xBasePos + 8 * i, yBasePos + y, 0, potionOffset, 9, 9, this.getColorBasedOnRow(iter));
                }
                if (hp % 2 != 1 || renderHearts >= 10) continue;
                this.drawTexturedModalRect(xBasePos + 8 * renderHearts, yBasePos, 9, potionOffset, 9, 9, this.getColorBasedOnRow(iter));
            }
            FontRenderer renderer = mc.field_71466_p;
            String renderedString = health + "/" + MathHelper.func_76143_f((double)attrMaxHealth.func_111126_e());
            GL11.glPushMatrix();
            float scale = 0.5f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            renderer.func_78261_a(renderedString, (int)((float)(xBasePos - renderedString.length() * 6 + 20) / scale), (int)((float)(yBasePos + 3) / scale), 0xAA0000);
            GL11.glPopMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(icons);
            GuiIngameForge.left_height += 10;
            if (absorb > 0.0f) {
                GuiIngameForge.left_height += 10;
            }
            event.setCanceled(true);
        }
    }

    public int getColorBasedOnRow(int rowNumber) {
        if (rowNumber >= colors.length) {
            return colors[colors.length - 1];
        }
        return colors[rowNumber];
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6, int color) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78378_d(color);
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }
}

