/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.util.pregen;

import chylex.hee.world.structure.ComponentScatteredFeatureCustom;
import chylex.hee.world.structure.util.pregen.ITileEntityGenerator;
import chylex.hee.world.structure.util.pregen.LargeStructureChunk;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public final class LargeStructureWorld {
    private static final LargeStructureChunk emptyFallbackChunk = new LargeStructureChunk.Empty(0, 0, 128);
    private final LargeStructureChunk[][] chunks;
    private LargeStructureChunk lastActiveChunk;

    public LargeStructureWorld(ComponentScatteredFeatureCustom structure) {
        if (structure == null) {
            this.chunks = new LargeStructureChunk[0][0];
            return;
        }
        this.chunks = new LargeStructureChunk[structure.getSizeX() >> 4][structure.getSizeZ() >> 4];
        int chunkXSize = structure.getSizeX() >> 4;
        int chunkZSize = structure.getSizeZ() >> 4;
        for (int z = 0; z < chunkZSize; ++z) {
            for (int x = 0; x < chunkXSize; ++x) {
                this.chunks[x][z] = new LargeStructureChunk(x, z, structure.getSizeY());
            }
        }
    }

    public int getChunkAmountX() {
        return this.chunks.length;
    }

    public int getChunkAmountZ() {
        return this.chunks[0].length;
    }

    public LargeStructureChunk getChunkFromChunkCoords(int chunkX, int chunkZ) {
        return chunkX < 0 || chunkZ < 0 || chunkX >= this.chunks.length || chunkZ >= this.chunks[0].length ? emptyFallbackChunk : this.chunks[chunkX][chunkZ];
    }

    private LargeStructureChunk getChunk(int blockX, int blockZ) {
        if (this.lastActiveChunk != null && blockX >> 4 == this.lastActiveChunk.x && blockZ >> 4 == this.lastActiveChunk.z) {
            return this.lastActiveChunk;
        }
        if (blockX < 0 || blockZ < 0 || blockX >= this.chunks.length * 16 || blockZ >= this.chunks[0].length * 16) {
            return emptyFallbackChunk;
        }
        this.lastActiveChunk = this.chunks[blockX >> 4][blockZ >> 4];
        return this.lastActiveChunk;
    }

    private int xInChunk(int blockX) {
        return this.lastActiveChunk != null ? blockX - this.lastActiveChunk.x * 16 : 0;
    }

    private int zInChunk(int blockZ) {
        return this.lastActiveChunk != null ? blockZ - this.lastActiveChunk.z * 16 : 0;
    }

    public void setBlock(int blockX, int blockY, int blockZ, Block block) {
        this.getChunk(blockX, blockZ).setBlock(this.xInChunk(blockX), blockY, this.zInChunk(blockZ), block, 0, false);
    }

    public void setBlock(int blockX, int blockY, int blockZ, Block block, int metadata) {
        this.getChunk(blockX, blockZ).setBlock(this.xInChunk(blockX), blockY, this.zInChunk(blockZ), block, metadata, false);
    }

    public void setBlock(int blockX, int blockY, int blockZ, Block block, int metadata, boolean scheduleUpdate) {
        this.getChunk(blockX, blockZ).setBlock(this.xInChunk(blockX), blockY, this.zInChunk(blockZ), block, metadata, scheduleUpdate);
    }

    public Block getBlock(int blockX, int blockY, int blockZ) {
        return this.getChunk(blockX, blockZ).getBlock(this.xInChunk(blockX), blockY, this.zInChunk(blockZ));
    }

    public int getMetadata(int blockX, int blockY, int blockZ) {
        return this.getChunk(blockX, blockZ).getMetadata(this.xInChunk(blockX), blockY, this.zInChunk(blockZ));
    }

    public int getHighestY(int blockX, int blockZ) {
        LargeStructureChunk chunk = this.getChunk(blockX, blockZ);
        for (int yy = chunk.getHighestBlockY(); yy > 0; --yy) {
            if (this.isAir(blockX, yy, blockZ)) continue;
            return yy;
        }
        return 0;
    }

    public boolean isAir(int blockX, int blockY, int blockZ) {
        return this.getBlock(blockX, blockY, blockZ) == Blocks.field_150350_a;
    }

    public void setTileEntityGenerator(int blockX, int blockY, int blockZ, String key, ITileEntityGenerator tileGen) {
        this.getChunk(blockX, blockZ).addTileEntityGenerator(this.xInChunk(blockX), blockY, this.zInChunk(blockZ), key, tileGen);
    }

    public void addEntity(Entity entity) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        this.getChunk(x, z).addEntity(entity, this.xInChunk(x), this.zInChunk(z));
    }

    public <T extends Entity> List<T> getAllEntities(Class<T> exactClassToMatch) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int z = 0; z < this.chunks[x].length; ++z) {
                for (Entity e : this.chunks[x][z].getAllEntities()) {
                    if (e.getClass() != exactClassToMatch) continue;
                    list.add(e);
                }
            }
        }
        return list;
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int z = 0; z < this.chunks[x].length; ++z) {
                nbt.func_74782_a(x + "-" + z, (NBTBase)this.chunks[x][z].saveToNBT());
            }
        }
        return nbt;
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int z = 0; z < this.chunks[x].length; ++z) {
                this.chunks[x][z].loadFromNBT(nbt.func_74775_l(x + "-" + z));
            }
        }
    }
}

