/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature;

import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.item.ItemKnowledgeNote;
import chylex.hee.item.ItemMusicDisk;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.collections.weight.ObjectWeightPair;
import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.feature.blobs.BlobGenerator;
import chylex.hee.world.feature.blobs.BlobPattern;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.blobs.generators.BlobGeneratorChain;
import chylex.hee.world.feature.blobs.generators.BlobGeneratorFromCenter;
import chylex.hee.world.feature.blobs.generators.BlobGeneratorRecursive;
import chylex.hee.world.feature.blobs.generators.BlobGeneratorSingle;
import chylex.hee.world.feature.blobs.generators.BlobGeneratorSingleCut;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorCave;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorChest;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorCover;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorEndermanSpawner;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorFiller;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorLake;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorLiquidFall;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorOreCluster;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorOreScattered;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorPlant;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorSpikes;
import chylex.hee.world.feature.blobs.populators.BlobPopulatorTransportBeacon;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.loot.IItemPostProcessor;
import chylex.hee.world.loot.LootItemStack;
import chylex.hee.world.loot.WeightedLootList;
import chylex.hee.world.util.IRandomAmount;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenBlob
extends WorldGenerator {
    private static final WeightedList<ObjectWeightPair<BlobType>> typesClose = new WeightedList((IWeightProvider[])new ObjectWeightPair[0]);
    private static final WeightedList<ObjectWeightPair<BlobType>> typesFar = new WeightedList((IWeightProvider[])new ObjectWeightPair[0]);
    private static final DecoratorFeatureGenerator.IDecoratorGenPass genSmootherPass;
    public static final HeeDebugCommand.HeeTest $debugTest;

    private BlobType getBlobType(Random rand, int x, int z) {
        double dist = MathUtil.distance(x, z);
        if (dist < 180.0) {
            return BlobType.COMMON;
        }
        if (dist < 340.0) {
            return typesClose.getRandomItem(rand).getObject();
        }
        return typesFar.getRandomItem(rand).getObject();
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        BlockPosM tmpPos = BlockPosM.tmp();
        if (tmpPos.set(x - 7, y, z).getBlock((IBlockAccess)world) != Blocks.field_150350_a || tmpPos.set(x + 7, y, z).getBlock((IBlockAccess)world) != Blocks.field_150350_a || tmpPos.set(x, y, z - 7).getBlock((IBlockAccess)world) != Blocks.field_150350_a || tmpPos.set(x, y, z + 7).getBlock((IBlockAccess)world) != Blocks.field_150350_a || tmpPos.set(x, y - 7, z).getBlock((IBlockAccess)world) != Blocks.field_150350_a || tmpPos.set(x, y + 7, z).getBlock((IBlockAccess)world) != Blocks.field_150350_a || tmpPos.set(x, y - 15, z).getBlock((IBlockAccess)world) != Blocks.field_150350_a || tmpPos.set(x, y + 15, z).getBlock((IBlockAccess)world) != Blocks.field_150350_a) {
            return false;
        }
        DecoratorFeatureGenerator gen = new DecoratorFeatureGenerator();
        Pair<BlobGenerator, List<BlobPopulator>> pattern = this.getBlobType((Random)rand, (int)x, (int)z).patterns.getRandomItem(rand).generatePattern(rand);
        ((BlobGenerator)pattern.getLeft()).generate(gen, rand);
        gen.runPass(genSmootherPass);
        for (BlobPopulator populator : (List)pattern.getRight()) {
            populator.generate(gen, rand);
        }
        if (gen.getOutOfBoundsCounter() > 6) {
            return false;
        }
        gen.generate(world, rand, x, y, z);
        return true;
    }

    static {
        typesClose.add(ObjectWeightPair.of(BlobType.COMMON, 50));
        typesClose.add(ObjectWeightPair.of(BlobType.UNCOMMON, 7));
        typesFar.add(ObjectWeightPair.of(BlobType.COMMON, 42));
        typesFar.add(ObjectWeightPair.of(BlobType.UNCOMMON, 7));
        typesFar.add(ObjectWeightPair.of(BlobType.RARE, 1));
        BlobType.COMMON.patterns.addAll(new BlobPattern[]{new BlobPattern(1).addGenerators(new BlobGenerator[]{new BlobGeneratorFromCenter(10).amount(IRandomAmount.preferSmaller, 2, 6).rad(2.5, 4.5).dist(3.5, 6.0), new BlobGeneratorSingle(9).rad(2.0, 5.0), new BlobGeneratorRecursive(8).baseAmount(IRandomAmount.linear, 1, 4).totalAmount(IRandomAmount.preferSmaller, 4, 10).recursionAmount(IRandomAmount.preferSmaller, 1, 5).recursionChance(0.1, 0.5, 0.8, 4).rad(2.6, 3.8).distMp(0.9, 1.5).cacheRecursionChance(), new BlobGeneratorFromCenter(7).amount(IRandomAmount.aroundCenter, 2, 8).rad(2.2, 5.0).dist(6.0, 6.0).limitDist().unifySize(), new BlobGeneratorSingle(4).rad(4.0, 10.0), new BlobGeneratorRecursive(4).baseAmount(IRandomAmount.linear, 1, 3).totalAmount(IRandomAmount.linear, 5, 9).recursionAmount(IRandomAmount.linear, 1, 3).recursionChance(0.4, 0.8, 0.5, 3).rad(3.0, 5.5).distMp(1.0, 1.7), new BlobGeneratorFromCenter(3).amount(IRandomAmount.linear, 4, 10).rad(2.4, 3.0).dist(2.0, 6.0), new BlobGeneratorChain(3).amount(IRandomAmount.linear, 3, 6).rad(2.5, 4.0).distMp(1.5, 2.5)}).addPopulators(new BlobPopulator[]{new BlobPopulatorCave(4).rad(2.2, 2.8).totalCaveAmount(IRandomAmount.linear, 2, 5).fullCaveAmount(IRandomAmount.preferSmaller, 1, 3).recursionChance(0.2, 0.8, 3).recursionRadMp(0.7, 0.9).cacheRecursionChance(), new BlobPopulatorSpikes(4).block(Blocks.field_150343_Z).amount(IRandomAmount.aroundCenter, 2, 10).maxOffset(16), new BlobPopulatorLiquidFall(2).block(BlockList.ender_goo).amount(IRandomAmount.preferSmaller, 1, 4).attempts(50, 80).requireBlockBelow(), new BlobPopulatorLake(2).block(BlockList.ender_goo).rad(2.0, 3.5), new BlobPopulatorOreCluster(4).block(BlockList.end_powder_ore).blockAmount(IRandomAmount.linear, 4, 7).iterationAmount(IRandomAmount.preferSmaller, 1, 4), new BlobPopulatorOreScattered(3).block(BlockList.igneous_rock_ore).blockAmount(IRandomAmount.preferSmaller, 1, 4).attempts(5, 10).visiblePlacementAttempts(10).knownBlockLocations(), new BlobPopulatorOreScattered(1).block(BlockList.end_powder_ore).blockAmount(IRandomAmount.aroundCenter, 3, 8).attempts(8, 15).visiblePlacementAttempts(5), new BlobPopulatorCover(1).block(Blocks.field_150343_Z).replaceTopBlock(), new BlobPopulatorPlant(3).block(BlockList.death_flower).blockAmount(IRandomAmount.linear, 3, 7).attempts(20, 35).knownBlockLocations()}).setPopulatorAmountProvider(IRandomAmount.preferSmaller, 1, 7)});
        BlobType.UNCOMMON.patterns.addAll(new BlobPattern[]{new BlobPattern(7).addGenerators(new BlobGenerator[]{new BlobGeneratorSingle(4).rad(2.5, 3.5), new BlobGeneratorSingle(1).rad(3.2, 5.2)}).addPopulators(new BlobPopulator[]{new BlobPopulatorOreScattered(1).block(BlockList.end_powder_ore).blockAmount(IRandomAmount.linear, 10, 20).attempts(40, 40).visiblePlacementAttempts(15).knownBlockLocations()}).setPopulatorAmountProvider(IRandomAmount.exact, 1, 1), new BlobPattern(6).addGenerators(new BlobGenerator[]{new BlobGeneratorSingleCut(1).cutRadMp(0.2, 0.7).cutDistMp(0.7, 1.5).rad(3.5, 6.0)}), new BlobPattern(4).addGenerators(new BlobGenerator[]{new BlobGeneratorChain(1).amount(IRandomAmount.aroundCenter, 4, 9).rad(2.7, 3.6).distMp(0.9, 1.1).unifySize()}), new BlobPattern(3).addGenerators(new BlobGenerator[]{new BlobGeneratorSingle(1).rad(3.8, 7.0)}).addPopulators(new BlobPopulator[]{new BlobPopulatorFiller(1).block(BlockList.ender_goo), new BlobPopulatorLiquidFall(1).block(BlockList.ender_goo).amount(IRandomAmount.linear, 14, 22).attempts(22, 36)}).setPopulatorAmountProvider(IRandomAmount.exact, 2, 2), new BlobPattern(2).addGenerators(new BlobGenerator[]{new BlobGeneratorSingle(1).rad(5.0, 7.5)}).addPopulators(new BlobPopulator[]{new BlobPopulatorFiller(1).block(Blocks.field_150350_a), new BlobPopulatorChest(1).loot(new WeightedLootList(new LootItemStack(ItemList.end_powder).setAmount(1, 5).setWeight(15), new LootItemStack(ItemList.knowledge_note).setWeight(10), new LootItemStack(Items.field_151079_bi).setAmount(1, 4).setWeight(9), new LootItemStack(Items.field_151133_ar).setWeight(7), new LootItemStack(ItemList.bucket_ender_goo).setWeight(5), new LootItemStack(ItemList.adventurers_diary).setWeight(5), new LootItemStack(ItemList.music_disk).setDamage(0, ItemMusicDisk.getRecordCount() - 1).setWeight(5), new LootItemStack(Items.field_151061_bv).setWeight(4)).addItemPostProcessor(new IItemPostProcessor(){

            @Override
            public ItemStack processItem(ItemStack is, Random rand) {
                return is.func_77973_b() == ItemList.knowledge_note ? ItemKnowledgeNote.setRandomNote(is, rand, 3) : is;
            }
        }), IRandomAmount.preferSmaller, 3, 10).onlyInside(), new BlobPopulatorCover(1).block(BlockList.ender_goo)}).setPopulatorAmountProvider(IRandomAmount.exact, 3, 3), new BlobPattern(2).addGenerators(new BlobGenerator[]{new BlobGeneratorFromCenter(1).amount(IRandomAmount.linear, 1, 5).rad(2.6, 4.5).dist(3.2, 5.5)}).addPopulators(new BlobPopulator[]{new BlobPopulatorSpikes(1).block(Blocks.field_150350_a).amount(IRandomAmount.linear, 25, 42)}).setPopulatorAmountProvider(IRandomAmount.exact, 1, 1)});
        BlobType.RARE.patterns.addAll(new BlobPattern[]{new BlobPattern(3).addGenerators(new BlobGenerator[]{new BlobGeneratorFromCenter(10).amount(IRandomAmount.preferSmaller, 3, 6).rad(2.7, 4.5).dist(3.2, 5.0), new BlobGeneratorRecursive(8).baseAmount(IRandomAmount.linear, 1, 3).totalAmount(IRandomAmount.preferSmaller, 4, 8).recursionAmount(IRandomAmount.preferSmaller, 1, 3).recursionChance(0.2, 0.45, 0.7, 3).rad(2.5, 4.0).distMp(0.9, 1.5), new BlobGeneratorRecursive(5).baseAmount(IRandomAmount.linear, 2, 4).totalAmount(IRandomAmount.preferSmaller, 5, 10).recursionAmount(IRandomAmount.preferSmaller, 1, 4).recursionChance(0.1, 0.4, 0.7, 4).rad(2.5, 4.0).distMp(1.0, 1.4).cacheRecursionChance(), new BlobGeneratorSingle(4).rad(2.5, 5.2), new BlobGeneratorChain(4).amount(IRandomAmount.linear, 2, 5).rad(3.0, 4.0).distMp(1.75, 2.5), new BlobGeneratorFromCenter(3).amount(IRandomAmount.preferSmaller, 3, 6).rad(2.7, 4.5).dist(3.2, 5.0).unifySize()}).addPopulators(new BlobPopulator[]{new BlobPopulatorTransportBeacon(1)}).setPopulatorAmountProvider(IRandomAmount.exact, 1, 1), new BlobPattern(2).addGenerators(new BlobGenerator[]{new BlobGeneratorSingle(1).rad(2.9, 4.9), new BlobGeneratorChain(1).amount(IRandomAmount.aroundCenter, 2, 5).rad(2.4, 2.8).distMp(1.0, 2.0), new BlobGeneratorFromCenter(1).amount(IRandomAmount.aroundCenter, 3, 6).rad(2.4, 3.1).dist(1.1, 1.5).limitDist()}).addPopulators(new BlobPopulator[]{new BlobPopulatorOreScattered(1).block(BlockList.end_powder_ore).blockAmount(IRandomAmount.aroundCenter, 25, 34).attempts(41, 54).visiblePlacementAttempts(3).knownBlockLocations(), new BlobPopulatorOreScattered(1).block(BlockList.igneous_rock_ore).blockAmount(IRandomAmount.aroundCenter, 13, 23).attempts(24, 31).knownBlockLocations(), new BlobPopulatorOreScattered(1).block(BlockList.endium_ore).blockAmount(IRandomAmount.preferSmaller, 4, 8).attempts(8, 13).visiblePlacementAttempts(4).knownBlockLocations()}).setPopulatorAmountProvider(IRandomAmount.exact, 3, 3), new BlobPattern(2).addGenerators(new BlobGenerator[]{new BlobGeneratorSingle(1).rad(6.0, 7.7)}).addPopulators(new BlobPopulator[]{new BlobPopulatorEndermanSpawner(1).blockAmount(IRandomAmount.aroundCenter, 3, 6).attempts(12, 17).visiblePlacementAttempts(8).knownBlockLocations(), new BlobPopulatorChest(1).loot(new WeightedLootList(new LootItemStack(ItemList.end_powder).setAmount(3, 9).setWeight(10), new LootItemStack(ItemList.stardust).setAmount(3, 7).setWeight(9), new LootItemStack(Items.field_151079_bi).setAmount(2, 5).setWeight(7), new LootItemStack(BlockList.obsidian_special).setAmount(3, 10).setDamage(0, 2).setWeight(6), new LootItemStack(ItemList.endium_ingot).setAmount(1, 3).setWeight(5), new LootItemStack(Items.field_151042_j).setAmount(1, 5).setWeight(5), new LootItemStack(Items.field_151137_ax).setAmount(2, 6).setWeight(4), new LootItemStack(Items.field_151043_k).setAmount(1, 5).setWeight(4), new LootItemStack(ItemList.igneous_rock).setAmount(1, 2).setWeight(4), new LootItemStack(BlockList.obsidian_special_glow).setAmount(3, 10).setDamage(0, 2).setWeight(3), new LootItemStack(Items.field_151045_i).setAmount(1, 3).setWeight(3), new LootItemStack(Items.field_151128_bU).setAmount(2, 7).setWeight(3), new LootItemStack(ItemList.music_disk).setDamage(0, ItemMusicDisk.getRecordCount() - 1).setWeight(3), new LootItemStack(Items.field_151074_bl).setAmount(2, 8).setWeight(2)), IRandomAmount.preferSmaller, 6, 10)}).setPopulatorAmountProvider(IRandomAmount.exact, 2, 2)});
        genSmootherPass = new DecoratorFeatureGenerator.IDecoratorGenPass(){
            private final byte[] airOffX = new byte[]{-1, 1, 0, 0, 0, 0};
            private final byte[] airOffY = new byte[]{0, 0, 0, 0, -1, 1};
            private final byte[] airOffZ = new byte[]{0, 0, -1, 1, 0, 0};

            @Override
            public void run(DecoratorFeatureGenerator gen, List<BlockPosM> blocks) {
                block0: for (BlockPosM loc : blocks) {
                    int adjacentAir = 0;
                    for (int a = 0; a < 6; ++a) {
                        if (gen.getBlock(loc.x + this.airOffX[a], loc.y + this.airOffY[a], loc.z + this.airOffZ[a]) != Blocks.field_150350_a || ++adjacentAir < 4) continue;
                        gen.setBlock(loc.x, loc.y, loc.z, Blocks.field_150350_a);
                        continue block0;
                    }
                }
            }
        };
        $debugTest = new HeeDebugCommand.HeeTest(){

            @Override
            public void run(String ... args) {
                WeightedList patterns = new WeightedList((IWeightProvider[])new BlobPattern[]{new BlobPattern(1).addGenerators(new BlobGenerator[]{new BlobGeneratorSingle(1).rad(6.0, 7.7)}).addPopulators(new BlobPopulator[]{new BlobPopulatorEndermanSpawner(1).blockAmount(IRandomAmount.aroundCenter, 3, 6).attempts(12, 17).visiblePlacementAttempts(8).knownBlockLocations(), new BlobPopulatorChest(1).loot(new WeightedLootList(new LootItemStack(ItemList.end_powder).setAmount(3, 9).setWeight(10), new LootItemStack(ItemList.stardust).setAmount(3, 7).setWeight(9), new LootItemStack(Items.field_151079_bi).setAmount(2, 5).setWeight(7), new LootItemStack(BlockList.obsidian_special).setAmount(3, 10).setDamage(0, 2).setWeight(6), new LootItemStack(ItemList.endium_ingot).setAmount(1, 3).setWeight(5), new LootItemStack(Items.field_151042_j).setAmount(1, 5).setWeight(5), new LootItemStack(Items.field_151137_ax).setAmount(2, 6).setWeight(4), new LootItemStack(Items.field_151043_k).setAmount(1, 5).setWeight(4), new LootItemStack(ItemList.igneous_rock).setAmount(1, 2).setWeight(4), new LootItemStack(BlockList.obsidian_special_glow).setAmount(3, 10).setDamage(0, 2).setWeight(3), new LootItemStack(Items.field_151045_i).setAmount(1, 3).setWeight(3), new LootItemStack(Items.field_151128_bU).setAmount(2, 7).setWeight(3), new LootItemStack(ItemList.music_disk).setDamage(0, ItemMusicDisk.getRecordCount() - 1).setWeight(3), new LootItemStack(Items.field_151074_bl).setAmount(2, 8).setWeight(2)), IRandomAmount.preferSmaller, 6, 10)}).setPopulatorAmountProvider(IRandomAmount.exact, 2, 2)});
                DecoratorFeatureGenerator gen = new DecoratorFeatureGenerator();
                Pair<BlobGenerator, List<BlobPopulator>> pattern = ((BlobPattern)patterns.getRandomItem(this.world.field_73012_v)).generatePattern(this.world.field_73012_v);
                Stopwatch.time("WorldGenBlob - test blob generator");
                ((BlobGenerator)pattern.getLeft()).generate(gen, this.world.field_73012_v);
                Stopwatch.finish("WorldGenBlob - test blob generator");
                Stopwatch.time("WorldGenBlob - test smoother pass");
                gen.runPass(genSmootherPass);
                Stopwatch.finish("WorldGenBlob - test smoother pass");
                Stopwatch.time("WorldGenBlob - test pattern generator");
                for (BlobPopulator populator : (List)pattern.getRight()) {
                    populator.generate(gen, this.world.field_73012_v);
                }
                Stopwatch.finish("WorldGenBlob - test pattern generator");
                Stopwatch.time("WorldGenBlob - test generate");
                gen.generate(this.world, this.world.field_73012_v, (int)this.player.field_70165_t + 10, (int)this.player.field_70163_u - 5, (int)this.player.field_70161_v);
                Stopwatch.finish("WorldGenBlob - test generate");
            }
        };
    }

    private static enum BlobType {
        COMMON,
        UNCOMMON,
        RARE;

        WeightedList<BlobPattern> patterns = new WeightedList((IWeightProvider[])new BlobPattern[0]);
    }
}

