/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world;

import chylex.hee.system.logging.Stopwatch;
import chylex.hee.world.WorldProviderHardcoreEnd;
import chylex.hee.world.biome.BiomeGenHardcoreEnd;
import chylex.hee.world.structure.island.ComponentIsland;
import chylex.hee.world.structure.island.StructureIsland;
import chylex.hee.world.structure.tower.ComponentTower;
import chylex.hee.world.structure.tower.StructureTower;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.Hashtable;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public final class DimensionOverride {
    public static void setup() {
        Stopwatch.time("DimensionOverride");
        BiomeGenBase.func_150565_n()[9] = BiomeGenBase.field_76779_k = new BiomeGenHardcoreEnd(9).func_76739_b(0x8080FF).func_76735_a("Sky").func_76745_m();
        MapGenStructureIO.func_143034_b(StructureTower.class, (String)"hardcoreenderdragon_EndTower");
        MapGenStructureIO.func_143031_a(ComponentTower.class, (String)"hardcoreenderdragon_EndTowerC");
        MapGenStructureIO.func_143034_b(StructureIsland.class, (String)"hardcoreenderdragon_EndIsland");
        MapGenStructureIO.func_143031_a(ComponentIsland.class, (String)"hardcoreenderdragon_EndIslandC");
        if (BiomeGenHardcoreEnd.overrideWorldGen) {
            MinecraftForge.EVENT_BUS.register((Object)new DimensionOverride());
        }
        Stopwatch.finish("DimensionOverride");
    }

    public static void postInit() {
        if (!(BiomeGenBase.field_76779_k instanceof BiomeGenHardcoreEnd)) {
            throw new RuntimeException("End biome class mismatch, Hardcore Ender Expansion cannot proceed! Biome class: " + BiomeGenBase.field_76779_k.getClass().getName());
        }
        ((BiomeGenHardcoreEnd)BiomeGenBase.func_150568_d((int)9)).overrideMobLists();
        DimensionManager.unregisterProviderType((int)1);
        DimensionManager.registerProviderType((int)1, WorldProviderHardcoreEnd.class, (boolean)false);
    }

    public static void verifyIntegrity() {
        try {
            Field f = DimensionManager.class.getDeclaredField("providers");
            f.setAccessible(true);
            Class cls = (Class)((Hashtable)f.get(null)).get(1);
            if (cls != WorldProviderHardcoreEnd.class) {
                throw new RuntimeException("End world provider class mismatch, Hardcore Ender Expansion cannot proceed! Provider class: " + (cls == null ? "<null>" : cls.getName()));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException e) {
            throw new RuntimeException("End world provider check failed!", e);
        }
    }

    private DimensionOverride() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (e.world.field_73011_w.field_76574_g == 1 && e.world instanceof WorldServer) {
            WorldServer world = (WorldServer)e.world;
            world.field_73059_b = new ChunkProviderServerOverride(world);
            world.field_73020_y = world.field_73059_b;
        }
    }

    public static final class ChunkProviderServerOverride
    extends ChunkProviderServer {
        public ChunkProviderServerOverride(WorldServer world) {
            super(world, world.field_73059_b.field_73247_e, world.field_73059_b.field_73246_d);
        }

        public void func_73153_a(IChunkProvider provider, int x, int z) {
            Chunk chunk = this.func_73154_d(x, z);
            if (!chunk.field_76646_k) {
                chunk.func_150809_p();
                if (this.field_73246_d != null) {
                    this.field_73246_d.func_73153_a(provider, x, z);
                    chunk.func_76630_e();
                }
            }
        }
    }
}

