/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.commands;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.system.commands.BaseCommand;
import chylex.hee.system.commands.DebugBoard;
import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.test.UnitTester;
import chylex.hee.system.test.data.RunTime;
import com.google.common.reflect.ClassPath;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.ArrayUtils;

public class HeeDebugCommand
extends BaseCommand {
    public static float overrideWingSpeed = 1.0f;

    public HeeDebugCommand() {
        super("heedebug");
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (!Log.isDebugEnabled()) {
            this.sendMessage(sender, "Debug mode is not enabled.");
            return;
        }
        if (args.length == 0) {
            for (String s : (EnumChatFormatting.GREEN + "Available commands:\n" + "/heedebug dragon-set-target <newtarget>\n" + "/heedebug dragon-wing-speed <newspeed>\n" + "/heedebug dragon-attack-end\n" + "/heedebug dragon-freeze\n" + "/heedebug dragon-debug-start\n" + "/heedebug dragon-debug-stop\n" + "/heedebug viewitems\n" + "/heedebug speedup\n" + "/heedebug noweather\n" + "/heedebug stopwatch\n" + "/heedebug test <testid>\n" + "/heedebug unit [trigger]").split("\n")) {
                this.sendMessage(sender, s);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("dragon-set-target") && args.length == 2) {
            EntityBossDragon dragon = HeeDebugCommand.getDragon();
            if (dragon == null) {
                return;
            }
            if (args[1].equals("null")) {
                dragon.target = null;
                this.sendMessage(sender, "Target cancelled.");
                return;
            }
            boolean found = false;
            for (EntityPlayer player : dragon.field_70170_p.field_73010_i) {
                if (!player.func_70005_c_().equalsIgnoreCase(args[1])) continue;
                dragon.trySetTarget(player);
                found = true;
                break;
            }
            if (!found) {
                this.sendMessage(sender, "No such player.");
                return;
            }
        } else if (args[0].equalsIgnoreCase("dragon-wing-speed") && args.length == 2) {
            try {
                overrideWingSpeed = Float.parseFloat(args[1]);
            }
            catch (NumberFormatException e) {
                this.sendMessage(sender, "Invalid number.");
            }
        } else if (args[0].equalsIgnoreCase("dragon-attack-end")) {
            EntityBossDragon dragon = HeeDebugCommand.getDragon();
            if (dragon != null) {
                dragon.forceAttackEnd = true;
            }
        } else if (args[0].equalsIgnoreCase("dragon-freeze")) {
            EntityBossDragon dragon = HeeDebugCommand.getDragon();
            if (dragon != null) {
                dragon.frozen = !dragon.frozen;
            }
        } else if (args[0].equalsIgnoreCase("dragon-debug-start")) {
            DebugBoard.startDebug((World)DimensionManager.getWorld((int)1));
        } else if (args[0].equalsIgnoreCase("dragon-debug-stop")) {
            DebugBoard.stopDebug();
        } else if (args[0].equalsIgnoreCase("viewitems")) {
            HardcoreEnderExpansion.proxy.openGui("itemviewer");
        } else if (args[0].equalsIgnoreCase("speedup")) {
            HardcoreEnderExpansion.proxy.openGui("speedup");
        } else if (args[0].equalsIgnoreCase("noweather")) {
            for (WorldServer world : DimensionManager.getWorlds()) {
                WorldInfo info = world.func_72912_H();
                info.func_76084_b(false);
                info.func_76069_a(false);
                info.func_76080_g(Integer.MAX_VALUE);
                info.func_76090_f(Integer.MAX_VALUE);
            }
        } else if (args[0].equalsIgnoreCase("stopwatch")) {
            Stopwatch.isEnabled = !Stopwatch.isEnabled;
        } else {
            if (args[0].equalsIgnoreCase("test") && args.length >= 2 && sender instanceof EntityPlayer) {
                try {
                    Stopwatch.time("HeeDebugCommand - test");
                    boolean found = false;
                    ClassPath path = ClassPath.from((ClassLoader)HeeDebugCommand.class.getClassLoader());
                    for (ClassPath.ClassInfo clsInfo : path.getAllClasses()) {
                        if (!clsInfo.getSimpleName().equals(args[1]) || !clsInfo.getPackageName().startsWith("chylex.hee")) continue;
                        HeeTest test = (HeeTest)clsInfo.load().getField("$debugTest").get(null);
                        test.player = (EntityPlayer)sender;
                        test.world = test.player.field_70170_p;
                        try {
                            test.run((String[])ArrayUtils.subarray((Object[])args, (int)2, (int)args.length));
                            this.sendMessage(sender, "Test completed.");
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            this.sendMessage(sender, "Test failed.");
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.sendMessage(sender, "Test not found.");
                    }
                    Stopwatch.finish("HeeDebugCommand - test");
                }
                catch (Throwable t) {
                    this.sendMessage(sender, "Test not found.");
                }
                return;
            }
            if (args[0].equalsIgnoreCase("unit") && sender instanceof EntityPlayer) {
                StringBuilder build = new StringBuilder();
                for (int a = 1; a < args.length; ++a) {
                    build.append(args[a]).append(' ');
                }
                UnitTester.trigger(RunTime.INGAME, args.length > 1 ? build.deleteCharAt(build.length() - 1).toString() : "");
            } else if (args[0].equalsIgnoreCase("tmp") && sender instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)sender;
            } else {
                this.sendMessage(sender, "Unknown command.");
                return;
            }
        }
        this.sendMessage(sender, "Request processed.");
    }

    public static final EntityBossDragon getDragon() {
        WorldServer world = DimensionManager.getWorld((int)1);
        for (Object o : world.field_72996_f) {
            if (!(o instanceof EntityBossDragon)) continue;
            return (EntityBossDragon)o;
        }
        return null;
    }

    public static abstract class HeeTest {
        protected World world;
        protected EntityPlayer player;

        public abstract void run(String ... var1);
    }
}

