/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.essence.handler;

import chylex.hee.api.interfaces.IAcceptFieryEssence;
import chylex.hee.mechanics.enhancements.types.EssenceAltarEnhancements;
import chylex.hee.mechanics.essence.handler.AltarActionHandler;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C11ParticleAltarOrb;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityEssenceAltar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class FieryEssenceHandler
extends AltarActionHandler {
    private byte essenceUsageCounter = (byte)-100;

    public FieryEssenceHandler(TileEntityEssenceAltar altar) {
        super(altar);
    }

    @Override
    public void onUpdate() {
        List<Enum> enhancementList = this.altar.getEnhancements();
        World world = this.altar.func_145831_w();
        int level = this.altar.getEssenceLevel();
        int n = 35 + Math.min(60, level >> 3);
        boolean drained = false;
        int range = enhancementList.contains(EssenceAltarEnhancements.RANGE) ? 16 : 12;
        n += MathUtil.square(range - 12);
        boolean hasSpeedEnh = enhancementList.contains(EssenceAltarEnhancements.SPEED);
        if (hasSpeedEnh) {
            n = MathUtil.ceil((double)n * 2.25);
        }
        block0: for (int a = 0; a < n; ++a) {
            int b;
            int xx = this.altar.field_145851_c + world.field_73012_v.nextInt(1 + range) - (range >> 1);
            int yy = this.altar.field_145848_d + world.field_73012_v.nextInt(5) - 2;
            int zz = this.altar.field_145849_e + world.field_73012_v.nextInt(1 + range) - (range >> 1);
            Block block = this.altar.func_145831_w().func_147439_a(xx, yy, zz);
            TileEntity tile = this.altar.func_145831_w().func_147438_o(xx, yy, zz);
            drained = false;
            if (block == Blocks.field_150460_al || block == Blocks.field_150470_am || tile instanceof TileEntityFurnace) {
                TileEntityFurnace furnace = (TileEntityFurnace)tile;
                if (furnace == null || !this.canFurnaceSmelt(furnace)) continue;
                n = 1 + Math.min(8, level >> 6);
                if (hasSpeedEnh) {
                    n = MathUtil.ceil((double)n * 1.75);
                }
                for (b = 0; b < n && furnace.field_145961_j < 199; ++b) {
                    boolean hasNoFuel;
                    boolean bl = hasNoFuel = TileEntityFurnace.func_145952_a((ItemStack)furnace.func_70301_a(1)) == 0 && furnace.field_145956_a <= 100;
                    if (hasNoFuel && !furnace.func_145950_i()) {
                        if (block == Blocks.field_150460_al) {
                            BlockFurnace.func_149931_a((boolean)true, (World)world, (int)furnace.field_145851_c, (int)furnace.field_145848_d, (int)furnace.field_145849_e);
                        }
                        furnace.func_70296_d();
                        furnace.field_145956_a = 100;
                        furnace.field_145963_i = 1600;
                    }
                    if (hasNoFuel && furnace.field_145956_a < 100) {
                        furnace.field_145956_a = 100;
                        furnace.field_145963_i = 1600;
                    }
                    if (hasNoFuel && furnace.field_145961_j > 1 && furnace.field_145961_j < 197 && furnace.field_145961_j % 3 == 0 && world.field_73012_v.nextInt(3) == 0) {
                        --furnace.field_145961_j;
                    }
                    if (!hasNoFuel) {
                        ++furnace.field_145961_j;
                    }
                    if (!this.tryDrainEssence()) continue;
                    drained = true;
                    if (--level <= 0) break;
                }
                if (drained && world.field_73012_v.nextInt(6 + (n >> 1)) <= 4) {
                    this.createOrbParticle(xx, yy, zz);
                }
                return;
            }
            if (block == Blocks.field_150382_bo) {
                TileEntityBrewingStand stand = (TileEntityBrewingStand)this.altar.func_145831_w().func_147438_o(xx, yy, zz);
                if (stand == null || stand.func_145935_i() <= 1 || stand.func_145935_i() == 400) continue;
                n = 1 + Math.min(5, level >> 6);
                if (hasSpeedEnh) {
                    n = MathUtil.ceil((double)n * 1.75);
                }
                for (b = 0; b < n; ++b) {
                    stand.func_145845_h();
                    if (this.tryDrainEssence()) {
                        drained = true;
                        if (--level <= 0) continue block0;
                    }
                    if (stand.func_145935_i() <= 1) continue block0;
                }
                continue;
            }
            if (!(tile instanceof IAcceptFieryEssence)) continue;
            IAcceptFieryEssence acceptor = (IAcceptFieryEssence)tile;
            n = acceptor.getBoostAmount(level);
            if (hasSpeedEnh) {
                n = MathUtil.ceil((double)n * 1.75);
            }
            for (b = 0; b < n; ++b) {
                acceptor.boost();
                if (!this.tryDrainEssence()) continue;
                drained = true;
                if (--level <= 0) continue block0;
            }
        }
    }

    private boolean tryDrainEssence() {
        this.essenceUsageCounter = (byte)(this.essenceUsageCounter + 1);
        if (this.essenceUsageCounter > (this.altar.getEnhancements().contains(EssenceAltarEnhancements.EFFICIENCY) ? (byte)120 : 30)) {
            this.essenceUsageCounter = (byte)-120;
            this.altar.drainEssence(1);
            return true;
        }
        return false;
    }

    private void createOrbParticle(int targetX, int targetY, int targetZ) {
        PacketPipeline.sendToAllAround(this.altar, 64.0, (AbstractPacket)new C11ParticleAltarOrb(this.altar, (double)targetX + 0.5, (double)targetY + 0.5, (double)targetZ + 0.5));
    }

    @Override
    public void onTileWriteToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("F_essenceUsageCnt", this.essenceUsageCounter);
    }

    @Override
    public void onTileReadFromNBT(NBTTagCompound nbt) {
        this.essenceUsageCounter = nbt.func_74771_c("F_essenceUsageCnt");
    }

    private boolean canFurnaceSmelt(TileEntityFurnace furnace) {
        if (furnace.func_70301_a(0) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(furnace.func_70301_a(0));
        if (itemstack == null) {
            return false;
        }
        ItemStack input = furnace.func_70301_a(2);
        if (input == null) {
            return true;
        }
        if (!input.func_77969_a(itemstack)) {
            return false;
        }
        int result = input.field_77994_a + itemstack.field_77994_a;
        return result <= furnace.func_70297_j_() && result <= input.func_77976_d();
    }
}

